@extends('clientcontribution.base')
@section('action-content')
     <!-- Main content -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
<section class="content">
      <div class="box">
  <div class="box-header">
    <div class="row">
        <div class="col-sm-4">
          <h3 class="box-title">Client Contribution </h3>
        </div>
        <div class="col-sm-12">
<form id="paymentForm" class="form-horizontal" role="form" method="POST" action="{{ route('clientcontribution.store') }}">
                        {{ csrf_field() }}

@foreach ($employee as $employee)
  @if( Auth::user()->clientaccount_number == $employee->clientaccount_number )
    <div class="col-md-6">
      <input id="clientaccount_number" class="form-control" name="clientaccount_number" value="{{$employee->clientaccount_number}}" readonly>

                @if ($errors->has('clientaccount_number'))
                        <span class="help-block">
                  <strong>{{ $errors->first('clientaccount_number') }}</strong>
                                    </span>
                                @endif
                                @endif
                              @endforeach
                            </div>
  <div class="form-group col-md-4">
    <label for="email">Email Address</label>
    <input type="email" id="email-address" required />
  </div>
  <div class="form-group col-md-4">
    <label for="amount">Amount</label>
    <input type="tel" id="amount" required />
  </div>
  <div class="form-group col-md-4">
    <label for="first-name">First Name</label>
    <input type="text" id="first-name" />
  </div>
  <div class="form-group col-md-4">
    <label for="last-name">Last Name</label>
    <input type="text" id="last-name" />
  </div>
  <div class="form-submit">
    <button type="submit" onclick="payWithPaystack()"> Pay </button>
  </div>
</form>
</div>

<script src="https://js.paystack.co/v1/inline.js"></script>
<script>const paymentForm = document.getElementById('paymentForm');
paymentForm.addEventListener("submit", payWithPaystack, false);

function payWithPaystack(e) {
  e.preventDefault();

  let handler = PaystackPop.setup({
    key: 'pk_test_a9a41e84e0d01fea8c7f09809d2d2ce565f9dde1', // Replace with your public key
    email: document.getElementById("email-address").value,
    amount: document.getElementById("amount").value * 100,
    currency: 'GHS', // Use GHS for Ghana Cedis or USD for US Dollars
    ref: 'SIC-FSL'+Math.floor((Math.random() * 1000000000) + 1), // generates a pseudo-unique reference. Please replace with a reference you generated. Or remove the line entirely so our API will generate one for you
    // label: "Optional string that replaces customer email"
    onClose: function(){
      alert('Window closed.');
    },
    callback: function(response){
      let message = 'Payment complete! Reference: ' + response.reference;
      alert(message);

      window.location = "http://127.0.0.1:8000/"; 
        }
    });

    handler.openIframe();
}


</script>

 </section>
    <!-- /.content -->
  </div>
@endsection

