@extends('asset-mgt.interesttype.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Interest Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('interesttype.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('interesttype') ? ' has-error' : '' }}">
                            <label for="interesttype" class="col-md-4 control-label">Interest Type</label>

                            <div class="col-md-6">
                                <input id="interesttype" type="text" class="form-control" name="interesttype" value="{{ old('interesttype') }}" required autofocus>

                                @if ($errors->has('interesttype'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('interesttype') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
