@extends('asset-mgt.interest.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add new Interest type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('interest.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('interest') ? ' has-error' : '' }}">
                            <label for="interest_amount" class="col-md-4 control-label">Interest Amount</label>

                            <div class="col-md-6">
                                <input id="interest_amount" type="text" class="form-control" name="interest_amount" value="{{ old('interest_amount') }}" required autofocus>

                                @if ($errors->has('interest_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('interest_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
