@extends('asset-mgt.fixedincometype.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Fixed Income Type</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('fixedincometype.store') }}">
                        {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('fixedincometype_name') ? ' has-error' : '' }}">
                            <label for="fixedincometype_name" class="col-md-4 control-label">Fixed Income Type</label>

                            <div class="col-md-6">
                                <input id="fixedincometype_name" type="text" class="form-control" name="fixedincometype_name" value="{{ old('fixedincometype_name') }}" required autofocus>

                                @if ($errors->has('fixedincometype_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fixedincometype_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
