@extends('asset-mgt.fixedincomeproduct.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Fixed Income Products</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('fixedincomeproduct.update', ['id' => $Fixedincomeproducts->id]) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('fixedincomeproduct_name') ? ' has-error' : '' }}">
                            <label for="fixedincomeproduct_name" class="col-md-4 control-label">Fixed Income Product</label>

                            <div class="col-md-6">
                                <input id="fixedincomeproduct_name" type="text" class="form-control" name="fixedincomeproduct_name" value="{{ $Fixedincomeproducts->fixedincomeproduct_name }}" required autofocus>

                                @if ($errors->has('fixedincomeproduct_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fixedincomeproduct_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                          <div class="form-group">
                            <label class="col-md-4 control-label">Fixed Income Type</label>
                            <div class="col-md-6">
                                <select class="form-control" name="fixedincometype_id">
                                    @foreach ($Fixedincometypes as $Fixedincometypes)
                                        <option value="{{$Fixedincometypes->id}}" {{$Fixedincometypes->id == $Fixedincomeproducts->fixedincometype_id ? 'selected' : ''}}>{{$Fixedincometypes->fixedincometype_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
