@extends('asset-mgt.assetclassname.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Update Asset Class </div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('assetclassname.update', ['id' => $Assetclassnames->id]) }}">
                        <input type="hidden" name="_method" value="PATCH">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group{{ $errors->has('assetclass_name') ? ' has-error' : '' }}">
                            <label for="assetclass_name" class="col-md-4 control-label">Asset Class</label>

                            <div class="col-md-6">
                                <input id="assetclass_name" type="text" class="form-control" name="assetclass_name" value="{{ $Assetclassnames->assetclass_name }}" required autofocus>

                                @if ($errors->has('assetclass_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('assetclass_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                          <div class="form-group">
                            <label class="col-md-4 control-label">Asset Class Type</label>
                            <div class="col-md-6">
                                <select class="form-control" name="assetclasstype_id">
                                    @foreach ($Assetclasstypes as $Assetclasstypes)
                                        <option value="{{$Assetclasstypes->id}}" {{$Assetclasstypes->id == $Assetclassnames->assetclasstype_id ? 'selected' : ''}}>{{$Assetclasstypes->assetclasstype}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Update
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
