@extends('asset-mgt.assetclassname.base')

@section('action-content')
<div class="container">
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-default">
                <div class="panel-heading">Add New Asset Class</div>
                <div class="panel-body">
                    <form class="form-horizontal" role="form" method="POST" action="{{ route('assetclassname.store') }}">
                        {{ csrf_field() }}


                        <div class="form-group">
                            <label class="col-md-4 control-label">Asset Class Type</label>
                            <div class="col-md-6">
                                <select class="form-control" name="assetclasstype_id">
                                    @foreach ($Assetclasstype as $Assetclasstypes)
                                        <option value="{{$Assetclasstypes->id}}">{{$Assetclasstypes->assetclasstype}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group{{ $errors->has('assetclass_name') ? ' has-error' : '' }}">
                            <label for="assetclass_name" class="col-md-4 control-label">Asset Class</label>

                            <div class="col-md-6">
                                <input id="assetclass_name" type="text" class="form-control" name="assetclass_name" value="{{ old('assetclass_name') }}" required autofocus>

                                @if ($errors->has('assetclass_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('assetclass_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit" class="btn btn-primary">
                                    Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
