<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvestmentmodelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('investmentmodels', function (Blueprint $table) {
            $table->increments('id', true);
            $table->string('clientaccount_number', 60);
            $table->string('name', 60);
            $table->integer('fixedincometype_id')->unsigned();
            $table->foreign('fixedincometype_id')->references('id')->on('fixedincometypes');
            $table->integer('fixedincomeproduct_id')->unsigned();
            $table->foreign('fixedincomeproduct_id')->references('id')->on('fixedincomeproducts');
            $table->integer('interest_id')->unsigned();
            $table->foreign('interest_id')->references('id')->on('interests');
            $table->integer('interestratetype_id')->unsigned();
            $table->foreign('interestratetype_id')->references('id')->on('interestratetypes');
            $table->integer('interesttype_id')->unsigned();
            $table->foreign('interesttype_id')->references('id')->on('interesttypes');
            $table->integer('schedulemode_id')->unsigned();
            $table->foreign('schedulemode_id')->references('id')->on('schedulemodes');
            $table->integer('fundtype_id')->unsigned();
            $table->foreign('fundtype_id')->references('id')->on('fundtypes');
            $table->date('incident_date');
            $table->date('investmentstart_date');
            $table->date('investmentend_date');
            $table->integer('currency_id')->unsigned();
            $table->foreign('currency_id')->references('id')->on('currencies');
            $table->string('total_contribution', 50);
            $table->string('annualint_rate', 50);
            $table->string('interestonmaturity_amount', 50);
            $table->string('maturityvalue_amount', 50);
            $table->string('unclearedbalance_amount', 50);
            $table->string('transaction_amount', 50);
            $table->string('tenor', 50);
            $table->integer('interestdaybasis_id')->unsigned();
            $table->foreign('interestdaybasis_id')->references('id')->on('interestdays');
            $table->string('remarks', 200);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('investmentmodels');
    }
}
