<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStudentkycsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('studentkycs', function (Blueprint $table) {
            $table->increments('id', true);
            // $table->string('Employee_Id', 15);
            $table->string('clientaccount_number', 60);
            $table->string('lastname', 60);
            $table->string('firstname', 60);
            $table->string('middlename', 60);
            $table->integer('fundtype_id')->unsigned();
            $table->foreign('fundtype_id')->references('id')->on('fundtypes');
            $table->integer('country_id')->unsigned();
            $table->foreign('country_id')->references('id')->on('country');
            $table->integer('sex_id')->unsigned();
            $table->foreign('sex_id')->references('id')->on('sexes');
            $table->integer('accounttype_id')->unsigned();
            $table->foreign('accounttype_id')->references('id')->on('accounttypes');
            $table->integer('title_id')->unsigned();
            $table->foreign('title_id')->references('id')->on('titles');
            $table->date('birthdate');
            $table->integer('age')->unsigned();
            $table->integer('identificationtype_id')->unsigned();
            $table->foreign('identificationtype_id')->references('id')->on('identificationtypes');
            $table->integer('maritalstatus_id')->unsigned();
            $table->foreign('maritalstatus_id')->references('id')->on('maritalstatuses');
            $table->integer('residentialstatus_id')->unsigned();
            $table->foreign('residentialstatus_id')->references('id')->on('residentialstatuses');
            $table->string('phone_number', 20);
            $table->string('mobile_number', 20);
            $table->string('email_address_contact', 60);
            $table->string('identification_number', 60);
            $table->string('postal_address', 120);
            $table->string('digital_address_contact', 20);
            $table->string('residential_address', 120);
            $table->string('residential_permit', 60);
            $table->date('permit_issue_date');
            $table->string('place_of_issue_of_permit', 60);
            $table->date('permit_expiry_date');
            $table->date('ID_issue_date');
            $table->string('ID_place_of_issue', 60);
            $table->date('ID_expiry_date');
            $table->string('name_of_beneficiary_1', 60);
            $table->string('relationship_1', 60);
            $table->string('contact_1', 60);
            $table->string('name_of_beneficiary_2', 60);
            $table->string('relationship_2', 60);
            $table->string('contact_2', 60);
            $table->string('name_of_beneficiary_3', 60);
            $table->string('relationship_3', 60);
            $table->string('contact_3', 60);
            $table->string('name_of_beneficiary_4', 60);
            $table->string('relationship_4', 60);
            $table->string('contact_4', 60);
            $table->string('name_of_beneficiary_5', 60);
            $table->string('relationship_5', 60);
            $table->string('contact_5', 60);
            $table->integer('active_id')->unsigned();
            $table->foreign('active_id')->references('id')->on('actives')->default('0');
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->string('pictureID', 120);
            $table->string('passportpicture', 60);
            $table->string('signature_upload', 60);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('studentkycs');
    }
}
