<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWithdrawalformsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('withdrawalforms', function (Blueprint $table) {
            $table->increments('id', true);
            $table->string('clientaccount_number', 60);
            $table->integer('accounttype_id')->unsigned();
            $table->foreign('accounttype_id')->references('id')->on('accounttypes');
            $table->integer('fundtype_id')->unsigned();
            $table->foreign('fundtype_id')->references('id')->on('fundtypes');
            $table->string('name_on_investment', 120);
            $table->string('postal_address', 120);
            $table->string('email_address', 60);
            $table->string('mobile_number', 20);
            $table->string('amount_in_figures', 130);
            $table->string('amount_in_words', 130);
            $table->integer('reasonforwithdrawal_id')->unsigned();
            $table->foreign('reasonforwithdrawal_id')->references('id')->on('reasonforwithdrawals');
            $table->string('reason_other', 130);
            $table->integer('paymentoptions_id')->unsigned();
            $table->foreign('paymentoptions_id')->references('id')->on('paymentoptions');
            $table->integer('identificationtype_id')->unsigned();
            $table->foreign('identificationtype_id')->references('id')->on('identificationtypes');
            $table->string('identification_number', 60);
            $table->integer('withdrawalstatus_id')->unsigned();
            $table->foreign('withdrawalstatus_id')->references('id')->on('withdrawalstatus')->default('0');
            $table->integer('employee_id')->unsigned();
            $table->foreign('employee_id')->references('id')->on('employers');
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->string('signature_upload', 60);
            $table->string('cash_balance', 60);
            $table->string('authorising_user', 60); 
            $table->string('authorising_signature', 60); 
            $table->string('authorising_officer', 60); 
            $table->string('authorising_signature_officer', 60); 
            $table->string('authorising_manager', 60);
            $table->string('authorising_signature_manager', 60);
            $table->string('authorising_risk', 60);
            $table->string('authorising_signature_risk', 60);
            $table->date('date_processed', 255);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('withdrawalforms');
    }
}
