<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientContributionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_contributions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('clientaccount_number', 60);
            $table->string('name');
            $table->string('contribution_month', 60);
            $table->string('contribution_amount', 60);
            $table->string('year', 60);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_contributions');
    }
}
