`<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->increments('id', true);
            // $table->string('Employee_Id', 15);
            $table->string('clientaccount_number', 60);
            $table->string('lastname', 60);
            $table->string('firstname', 60);
            $table->string('maidenname', 60);
            $table->string('middlename', 60);
            $table->integer('state_id')->unsigned();
            $table->integer('fundtype_id')->unsigned();
            $table->foreign('fundtype_id')->references('id')->on('fundtypes');
            $table->integer('country_id')->unsigned();
            $table->foreign('state_id')->references('id')->on('state');
            $table->foreign('country_id')->references('id')->on('country');
            $table->integer('countryresidence_id')->unsigned();
            $table->foreign('countryresidence_id')->references('id')->on('countryresidences');
            $table->integer('sex_id')->unsigned();
            $table->foreign('sex_id')->references('id')->on('sexes');
            $table->integer('accounttype_id')->unsigned();
            $table->foreign('accounttype_id')->references('id')->on('accounttypes');
            $table->integer('title_id')->unsigned();
            $table->foreign('title_id')->references('id')->on('titles');
            $table->date('birthdate');
            $table->string('place_of_birth', 60);
            $table->integer('age')->unsigned();
            $table->integer('bank_id')->unsigned();
            $table->foreign('bank_id')->references('id')->on('banks');
            $table->integer('identificationtype_id')->unsigned();
            $table->foreign('identificationtype_id')->references('id')->on('identificationtypes');
            $table->integer('maritalstatus_id')->unsigned();
            $table->foreign('maritalstatus_id')->references('id')->on('maritalstatuses');
            $table->integer('investmenttframe_id')->unsigned();
            $table->foreign('investmenttframe_id')->references('id')->on('investmenttframes');
            $table->integer('sourceoffunds_id')->unsigned();
            $table->foreign('sourceoffunds_id')->references('id')->on('sourceoffunds');
            $table->integer('riskassessment_id')->unsigned();
            $table->foreign('riskassessment_id')->references('id')->on('riskassessments');
            $table->integer('residentialstatus_id')->unsigned();
            $table->foreign('residentialstatus_id')->references('id')->on('residentialstatuses');
            $table->integer('statementservice_id')->unsigned();
            $table->foreign('statementservice_id')->references('id')->on('statementservices');
            $table->integer('city_id')->unsigned();
            $table->foreign('city_id')->references('id')->on('cities');
            $table->string('phone_number', 20);
            $table->string('mobile_number', 20);
            $table->string('email_address_contact', 60);
            $table->string('bankaccount_name', 60);
            $table->string('bankaccount_number', 60);
            $table->string('bankbranch_name', 60);
            $table->string('identification_number', 60);
            $table->string('postal_address', 120);
            $table->string('residential_address', 120);
            $table->string('employer_name', 120);
            $table->string('employer_address', 120);
            $table->string('employment_years', 60);
            $table->string('employmentcurrent_years', 60);
            $table->string('employmentprevious_years', 60);
            $table->integer('employerincomerange_id')->unsigned();
            $table->foreign('employerincomerange_id')->references('id')->on('employerincomerange');
            $table->integer('employerstatus_id')->unsigned();
            $table->foreign('employerstatus_id')->references('id')->on('employerstatuses');
            $table->integer('statementfrequency_id')->unsigned();
            $table->foreign('statementfrequency_id')->references('id')->on('statementfrequencies');
            $table->string('other_statementfrequency', 60);
            $table->string('residential_permit', 60);
            $table->date('permit_issue_date');
            $table->string('place_of_issue_of_permit', 60);
            $table->date('permit_expiry_date');
            $table->string('occupation', 60);
            $table->string('profession', 60);
            $table->string('tin', 60);
            $table->string('nearest_landmark_contact', 60);
            $table->string('digital_address_contact', 60);
            $table->string('emergency_contact_name', 60);
            $table->string('relationship_to_client', 60);
            $table->string('emergency_contact_number', 60);
            $table->date('ID_issue_date');
            $table->string('ID_place_of_issue', 60);
            $table->date('ID_expiry_date');
            $table->string('nearest_landmark_employer', 60);
            $table->string('digital_address_employer', 60);
            $table->string('city_town_employer', 60);
            $table->string('nature_of_business', 60);
            $table->string('phone_number_employer', 20);
            $table->string('mobile_number_employer', 20);
            $table->string('email_address_employer', 60);
            $table->string('name_of_beneficiary_1', 60);
            $table->string('relationship_1', 60);
            $table->string('contact_1', 60);
            $table->string('percentage_1', 60);
            $table->integer('maritalstatus1_id')->unsigned();
            $table->foreign('maritalstatus1_id')->references('id')->on('maritalstatuses');
            $table->integer('sex1_id')->unsigned();
            $table->foreign('sex1_id')->references('id')->on('sexes');
            $table->date('bndob_1');
            $table->integer('country1_id')->unsigned();
            $table->foreign('country1_id')->references('id')->on('country');
            $table->integer('identificationtype1_id')->unsigned();
            $table->foreign('identificationtype1_id')->references('id')->on('identificationtypes');
            $table->string('bnidentification_number_1', 60);
            $table->date('ID_issue_date_1');
            $table->string('ID_place_of_issue_1', 60);
            $table->date('ID_expiry_date_1');
            $table->string('name_of_beneficiary_2', 60);
            $table->string('relationship_2', 60);
            $table->string('contact_2', 60);
            $table->string('percentage_2', 60);
            $table->integer('maritalstatus2_id')->unsigned();
            $table->foreign('maritalstatus2_id')->references('id')->on('maritalstatuses');
            $table->integer('sex2_id')->unsigned();
            $table->foreign('sex2_id')->references('id')->on('sexes');
            $table->date('bndob_2');
            $table->integer('country2_id')->unsigned();
            $table->foreign('country2_id')->references('id')->on('country');
            $table->integer('identificationtype2_id')->unsigned();
            $table->foreign('identificationtype2_id')->references('id')->on('identificationtypes');
            $table->string('bnidentification_number_2', 60);
            $table->date('ID_issue_date_2');
            $table->string('ID_place_of_issue_2', 60);
            $table->date('ID_expiry_date_2');
            $table->string('name_of_beneficiary_3', 60);
            $table->string('relationship_3', 60);
            $table->string('contact_3', 60);
            $table->string('percentage_3', 60);
            $table->integer('maritalstatus3_id')->unsigned();
            $table->foreign('maritalstatus3_id')->references('id')->on('maritalstatuses');
            $table->integer('sex3_id')->unsigned();
            $table->foreign('sex3_id')->references('id')->on('sexes');
            $table->date('bndob_3');
            $table->integer('country3_id')->unsigned();
            $table->foreign('country3_id')->references('id')->on('country');
            $table->integer('identificationtype3_id')->unsigned();
            $table->foreign('identificationtype3_id')->references('id')->on('identificationtypes');
            $table->string('bnidentification_number_3', 60);
            $table->date('ID_issue_date_3');
            $table->string('ID_place_of_issue_3', 60);
            $table->date('ID_expiry_date_3');
            $table->string('name_of_beneficiary_4', 60);
            $table->string('relationship_4', 60);
            $table->string('contact_4', 60);
            $table->string('percentage_4', 60);
            $table->integer('maritalstatus4_id')->unsigned();
            $table->foreign('maritalstatus4_id')->references('id')->on('maritalstatuses');
            $table->integer('sex4_id')->unsigned();
            $table->foreign('sex4_id')->references('id')->on('sexes');
            $table->integer('country4_id')->unsigned();
            $table->foreign('country4_id')->references('id')->on('country');
            $table->date('bndob_4');
            $table->integer('identificationtype4_id')->unsigned();
            $table->foreign('identificationtype4_id')->references('id')->on('identificationtypes');
            $table->string('bnidentification_number_4', 60);
            $table->date('ID_issue_date_4');
            $table->string('ID_place_of_issue_4', 60);
            $table->date('ID_expiry_date_4');
            $table->string('name_of_beneficiary_5', 60);
            $table->string('relationship_5', 60);
            $table->string('contact_5', 60);
            $table->string('percentage_5', 60);
            $table->integer('maritalstatus5_id')->unsigned();
            $table->foreign('maritalstatus5_id')->references('id')->on('maritalstatuses');
            $table->integer('sex5_id')->unsigned();
            $table->foreign('sex5_id')->references('id')->on('sexes');
            $table->date('bndob_5');
            $table->integer('country5_id')->unsigned();
            $table->foreign('country5_id')->references('id')->on('country');
            $table->integer('identificationtype5_id')->unsigned();
            $table->foreign('identificationtype5_id')->references('id')->on('identificationtypes');
            $table->string('bnidentification_number_5', 60);
            $table->date('ID_issue_date_5');
            $table->string('ID_place_of_issue_5', 60);
            $table->date('ID_expiry_date_5');
            $table->string('investobjective', 120);
            $table->string('nameassociatedbus', 120);
            $table->string('natureassciatedbus', 120);
            $table->integer('risktolerance_id')->unsigned();
            $table->foreign('risktolerance_id')->references('id')->on('risktolerances');
            $table->integer('modeofaccount_id')->unsigned();
            $table->foreign('modeofaccount_id')->references('id')->on('modeofaccounts');
            $table->integer('investmentknowledge_id')->unsigned();
            $table->foreign('investmentknowledge_id')->references('id')->on('investmentknowledges');
            $table->string('source_of_wealth', 120);
            $table->string('other_source_fund', 120);
            $table->string('initialinvest_account', 120);
            $table->integer('modeofdeposite_id')->unsigned();
            $table->foreign('modeofdeposite_id')->references('id')->on('modeofdeposites');
            $table->integer('topups_id')->unsigned();
            $table->foreign('topups_id')->references('id')->on('topups');
            $table->integer('withdrawal_id')->unsigned();
            $table->foreign('withdrawal_id')->references('id')->on('withdrawals');
            $table->string('regular_topup_amount', 120);
            $table->string('regular_withdrawal_amount', 120);
            $table->integer('active_id')->unsigned();
            $table->foreign('active_id')->references('id')->on('actives')->default('0');
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->string('pictureID', 120);
            $table->string('passportpicture', 60);
            $table->string('signature_upload', 60);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
