<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        'App\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        $this->registerPolicies($gate);

        $gate->define('isAdmin', function($admin){
            return $admin->user_type == 'admin';
        });

        $gate->define('isUser', function($admin){
            return $admin->user_type == 'user';
        });


        $gate->define('isManager', function($admin){
            return $admin->user_type == 'manager';
        });

        $gate->define('isAuditor', function($admin){
            return $admin->user_type == 'auditor';
        });

        $gate->define('isOfficer', function($admin){
            return $admin->user_type == 'officer';
        });

        $gate->define('isStudent', function($admin){
            return $admin->user_type == 'student';
        });

    }
}
