<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class studentkyc extends Model
{
    use HasFactory;
    
    /**
    * The attributes that aren't mass assignable.
    *
    * @var array
    */
    protected $guarded = [];

    protected $fillable = ['clientaccount_number', 'passportpicture', 'pictureID', 'signature_upload', 'lastname', 'firstname', 'middlename', 'fundtype_id', 'country_id', 'sex_id', 'accounttype_id', 'title_id', 'birthdate', 'age', 'identificationtype_id', 'maritalstatus_id', 'residentialstatus_id', 'phone_number', 'mobile_number', 'email_address_contact', 'digital_address_contact', 'identification_number', 'postal_address', 'residential_address', 'residential_permit', 'permit_issue_date', 'place_of_issue_of_permit', 'permit_expiry_date', 'ID_issue_date', 'ID_place_of_issue', 'ID_expiry_date', 'name_of_beneficiary_1', 'relationship_1', 'contact_1', 'name_of_beneficiary_2', 'relationship_2', 'contact_2', 'name_of_beneficiary_3', 'relationship_3', 'contact_3', 'name_of_beneficiary_4', 'relationship_4', 'contact_4', 'name_of_beneficiary_5', 'relationship_5', 'contact_5', 'active_id', 'user_id'];

   
    public function client_contribution(){
    	return $this->belongsTo('App\Models\studentkyc');
    }

    public function sex(){
    	return $this->belongsTo('App\Models\sex', 'sex_id', 'id');
    }

    public function region(){
    	return $this->belongsTo('App\Models\State', 'state_id', 'id');
    }

    public function clientContributions(){
        return $this->hasMany('App\Models\client_contribution', 'clientaccount_number', 'clientaccount_number');
    }

    public function accounttype(){
        return $this->belongsTo('App\Models\accounttype', 'accounttype_id', 'id');
    }

    public function Country(){
        return $this->belongsTo('App\Models\Country', 'country_id', 'id');
    }


    public function maritalstatus(){
        return $this->belongsTo('App\Models\maritalstatus', 'maritalstatus_id', 'id');
    }

    public function investmenttframe(){
        return $this->belongsTo('App\Models\Division', 'division_id', 'id');
    }

    public function bank(){
        return $this->belongsTo('App\Models\bank', 'bank_id', 'id');
    }

    public function active(){
        return $this->belongsTo('App\Models\active', 'active_id', 'id');
    }

    public function Pictureupload(){
        return $this->belongsTo('App\Models\Pictureupload', 'Pictureupload_id', 'id');
    }

    public function feedback(){
        return $this->hasMany('App\Models\feedback');
    }

    public function residentialstatus(){
        return $this->belongsTo('App\Models\residentialstatus', 'residentialstatus_id', 'id');
    }

    public function City(){
        return $this->belongsTo('App\Models\City', 'city_id', 'id');
    }

    public function fundtype(){
        return $this->belongsTo('App\Models\fundtype', 'fundtype_id', 'id');
    }

    public function Statementfrequency(){
        return $this->belongsTo('App\Models\Statementfrequency', 'statementfrequency_id', 'id');
    }

public function Countryresidence(){
        return $this->belongsTo('App\Models\Countryresidence', 'countryresidence_id', 'id');
    }

    public function risktolerance(){
        return $this->belongsTo('App\Models\risktolerance', 'risktolerance_id', 'id');
    }

    public function sourceoffunds(){
        return $this->belongsTo('App\Models\sourceoffunds', 'sourceoffunds_id', 'id');
    }


    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function title(){
        return $this->belongsTo('App\Models\title', 'title_id', 'id');
    }

    public function identificationtype(){
        return $this->belongsTo('App\Models\identificationtype', 'identificationtype_id', 'id');
    }

    public function Statementservice(){
        return $this->belongsTo('App\Models\Statementservice', 'statementservice_id', 'id');
    }

    public function Employerstatus(){
        return $this->belongsTo('App\Models\Employerstatus', 'employerstatus_id', 'id');
    }

    public function Employerincomerange(){
        return $this->belongsTo('App\Models\Employerincomerange', 'employerincomerange_id', 'id');
    }

    public function modeofdeposite(){
        return $this->belongsTo('App\Models\modeofdeposite', 'modeofdeposite_id', 'id');
    }

    public function topups(){
        return $this->belongsTo('App\Models\topups', 'topups_id', 'id');
    }
}
