<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class clientkycprofile extends Model
{
    use HasFactory;

    public function clientcontribution(){
        return $this->belongsTo('App\Models\Employee');
    }

    public function sex(){
        return $this->belongsTo('App\Models\sex', 'sex_id', 'id');
    }

    public function region(){
        return $this->belongsTo('App\Models\State', 'state_id', 'id');
    }

    public function clientcontributions(){
        return $this->hasMany('App\Models\clientcontribution', 'clientaccount_number', 'clientaccount_number');
    }

    public function accounttype(){
        return $this->belongsTo('App\Models\accounttype', 'accounttype_id', 'id');
    }

    public function Country(){
        return $this->belongsTo('App\Models\Country', 'country_id', 'id');
    }


    public function maritalstatus(){
        return $this->belongsTo('App\Models\maritalstatus', 'maritalstatus_id', 'id');
    }

    public function investmenttframe(){
        return $this->belongsTo('App\Models\Division', 'division_id', 'id');
    }

    public function bank(){
        return $this->belongsTo('App\Models\bank', 'bank_id', 'id');
    }

    public function active(){
        return $this->belongsTo('App\Models\active', 'active_id', 'id');
    }

    public function Pictureupload(){
        return $this->belongsTo('App\Models\Pictureupload', 'Pictureupload_id', 'id');
    }

    public function feedback(){
        return $this->hasMany('App\Models\feedback');
    }

    public function residentialstatus(){
        return $this->belongsTo('App\Models\residentialstatus', 'residentialstatus_id', 'id');
    }

    public function City(){
        return $this->belongsTo('App\Models\City', 'city_id', 'id');
    }

    public function fundtype(){
        return $this->belongsTo('App\Models\fundtype', 'fundtype_id', 'id');
    }

    public function Statementfrequency(){
        return $this->belongsTo('App\Models\Statementfrequency', 'statementfrequency_id', 'id');
    }

public function Countryresidence(){
        return $this->belongsTo('App\Models\Countryresidence', 'countryresidence_id', 'id');
    }

    public function risktolerance(){
        return $this->belongsTo('App\Models\risktolerance', 'risktolerance_id', 'id');
    }

    public function sourceoffunds(){
        return $this->belongsTo('App\Models\sourceoffunds', 'sourceoffunds_id', 'id');
    }


    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function title(){
        return $this->belongsTo('App\Models\title', 'title_id', 'id');
    }

    public function identificationtype(){
        return $this->belongsTo('App\Models\identificationtype', 'identificationtype_id', 'id');
    }

    public function Statementservice(){
        return $this->belongsTo('App\Models\Statementservice', 'statementservice_id', 'id');
    }

    public function Employerstatus(){
        return $this->belongsTo('App\Models\Employerstatus', 'employerstatus_id', 'id');
    }

    public function Employerincomerange(){
        return $this->belongsTo('App\Models\Employerincomerange', 'employerincomerange_id', 'id');
    }

    public function clientcontribution(){
        return $this->belongsTo('App\Models\studentkyc');
    }
}
