<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Withdrawalform extends Model
{
    use HasFactory;
    
    /**
    * The attributes that aren't mass assignable.
    *
    * @var array
    */
    protected $guarded = [];

    protected $fillable = ['clientaccount_number', 'accounttype_id', 'fundtype_id', 'name_on_investment', 'postal_address', 'email_address', 'mobile_number', 'amount_in_figures', 'amount_in_words', 'reasonforwithdrawal_id', 'reason_other', 'paymentoptions_id', 'identificationtype_id', 'identification_number', 'withdrawalstatus_id', 'employee_id', 'signature_upload', 'cash_balance', 'authorising_user', 'authorising_signature', 'authorising_officer', 'authorising_signature_officer', 'authorising_manager', 'authorising_signature_manager', 'authorising_risk', 'authorising_signature_risk', 'date_processed', 'user_id'];

   
    public function clientcontribution(){
        return $this->belongsTo('App\Withdrawalform');
    }
public function clientcontribution(){
        return $this->hasMany('App\clientcontribution', 'clientaccount_number', 'clientaccount_number');
    }
public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function Withdrawalform()
    {
        return $this->belongsTo('App\Withdrawalform');
    }

    public function reasonforwithdrawal()
    {
        return $this->belongsTo('App\reasonforwithdrawal', 'reasonforwithdrawal_id', 'id');
    }
}
