<?php

namespace App\Models;



use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;
    
    /**
    * The attributes that aren't mass assignable.
    *
    * @var array
    */
    protected $guarded = ['remember_token'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function Clientrptview(){
        return $this->hasMany('App\Clientrptview');
    }

    protected static function boot()
{
    parent::boot();

    static::creating(function ($user) {
        // When creating a new user, generate a unique client account number based on user type
        $user->clientaccount_number = static::generateAccountNumber($user->user_type);
    });
}

protected static function generateAccountNumber($userType)
{
    // Check the user type
    if ($userType === 'student') {
        // If user type is student, generate an account number starting with "STD"
        return 'STD' . strtoupper(uniqid());
    } else {
        // If user type is not student, generate an account number starting with "FSL"
        return 'FSL' . strtoupper(uniqid());
    }
}

    public function isAdmin()
    {
        return $this->user_type === 'admin';
    }

    public function studentkyc()
{
    return $this->hasOne(studentkyc::class);
}

public function hasSubmittedKYC()
    {
        // Check if there is a record in the employees table with the user's clientaccount_number
        return studentkyc::where('clientaccount_number', $this->clientaccount_number)->exists();
    }

}

    

