<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;
    
    /**
    * The attributes that aren't mass assignable.
    *
    * @var array
    */
    protected $guarded = [];

    protected $fillable = ['clientaccount_number', 'passportpicture', 'pictureID', 'signature_upload', 'lastname', 'firstname', 'maidenname', 'middlename', 'fundtype_id', 'country_id', 'countryresidence_id', 'sex_id', 'accounttype_id', 'title_id', 'birthdate', 'place_of_birth', 'age', 'bank_id', 'identificationtype_id', 'maritalstatus_id', 'investmenttframe_id', 'sourceoffunds_id', 'residentialstatus_id', 'statementservice_id', 'phone_number', 'mobile_number', 'email_address_contact', 'bankaccount_name', 'bankaccount_number', 'bankbranch_name', 'identification_number', 'postal_address', 'residential_address', 'employer_name', 'employer_address', 'employment_years','employmentcurrent_years', 'employmentprevious_years', 'employerincomerange_id', 'employerstatus_id', 'statementfrequency_id', 'other_statementfrequency', 'residential_permit', 'permit_issue_date', 'place_of_issue_of_permit', 'permit_expiry_date', 'occupation', 'profession', 'tin', 'nearest_landmark_contact', 'digital_address_contact', 'emergency_contact_name', 'relationship_to_client', 'emergency_contact_number', 'ID_issue_date', 'ID_place_of_issue', 'ID_expiry_date', 'nearest_landmark_employer', 'digital_address_employer', 'city_town_employer', 'nature_of_business', 'phone_number_employer', 'mobile_number_employer', 'email_address_employer', 'name_of_beneficiary_1', 'relationship_1', 'contact_1', 'percentage_1', 'maritalstatus1_id', 'sex1_id', 'bndob1', 'country1_id', 'identificationtype1_id', 'bnidentification_number_1', 'ID_issue_date_1', 'ID_place_of_issue_1', 'ID_expiry_date_1', 'name_of_beneficiary_2', 'relationship_2', 'contact_2', 'percentage_2', 'maritalstatus2_id', 'sex2_id', 'bndob2', 'country2_id', 'identificationtype2_id', 'bnidentification_number_2', 'ID_issue_date_2', 'ID_place_of_issue_2', 'ID_expiry_date_2', 'name_of_beneficiary_3', 'relationship_3', 'contact_3', 'percentage_3', 'maritalstatus3_id', 'sex3_id', 'sex3_id', 'bndob3', 'country3_id', 'identificationtype3_id', 'bnidentification_number_3', 'ID_issue_date_3', 'ID_place_of_issue_3', 'ID_expiry_date_3', 'name_of_beneficiary_4', 'relationship_4', 'contact_4', 'percentage_4', 'maritalstatus4_id', 'sex4_id', 'country4_id', 'bndob4', 'identificationtype4_id', 'bnidentification_number_4', 'ID_issue_date_4', 'ID_place_of_issue_4', 'ID_expiry_date_4', 'name_of_beneficiary_5', 'relationship_5', 'contact_5', 'percentage_5', 'maritalstatus5_id', 'sex5_id', 'bndob5', 'country5_id', 'identificationtype5_id', 'bnidentification_number_5', 'ID_issue_date_5', 'ID_place_of_issue_5', 'ID_expiry_date_5', 'investobjective', 'nameassociatedbus', 'natureassciatedbus', 'risktolerance_id', 'modeofaccount_id', 'investmentknowledge_id', 'source_of_wealth', 'other_source_fund', 'initialinvest_account', 'modeofdeposite_id', 'topups_id', 'withdrawal_id', 'regular_topup_amount', 'regular_withdrawal_amount', 'active_id', 'user_id'];

   
    public function client_contribution(){
    	return $this->belongsTo('App\Models\Employee');
    }

    public function sex(){
    	return $this->belongsTo('App\Models\sex', 'sex_id', 'id');
    }

    public function region(){
    	return $this->belongsTo('App\Models\State', 'state_id', 'id');
    }

    public function clientContributions(){
        return $this->hasMany('App\Models\client_contribution', 'clientaccount_number', 'clientaccount_number');
    }

    public function accounttype(){
        return $this->belongsTo('App\Models\accounttype', 'accounttype_id', 'id');
    }

    public function Country(){
        return $this->belongsTo('App\Models\Country', 'country_id', 'id');
    }


    public function maritalstatus(){
        return $this->belongsTo('App\Models\maritalstatus', 'maritalstatus_id', 'id');
    }

    public function investmenttframe(){
        return $this->belongsTo('App\Models\Division', 'division_id', 'id');
    }

    public function bank(){
        return $this->belongsTo('App\Models\bank', 'bank_id', 'id');
    }

    public function active(){
        return $this->belongsTo('App\Models\active', 'active_id', 'id');
    }

    public function Pictureupload(){
        return $this->belongsTo('App\Models\Pictureupload', 'Pictureupload_id', 'id');
    }

    public function feedback(){
        return $this->hasMany('App\Models\feedback');
    }

    public function residentialstatus(){
        return $this->belongsTo('App\Models\residentialstatus', 'residentialstatus_id', 'id');
    }

    public function City(){
        return $this->belongsTo('App\Models\City', 'city_id', 'id');
    }

    public function fundtype(){
        return $this->belongsTo('App\Models\fundtype', 'fundtype_id', 'id');
    }

    public function Statementfrequency(){
        return $this->belongsTo('App\Models\Statementfrequency', 'statementfrequency_id', 'id');
    }

public function Countryresidence(){
        return $this->belongsTo('App\Models\Countryresidence', 'countryresidence_id', 'id');
    }

    public function risktolerance(){
        return $this->belongsTo('App\Models\risktolerance', 'risktolerance_id', 'id');
    }

    public function sourceoffunds(){
        return $this->belongsTo('App\Models\sourceoffunds', 'sourceoffunds_id', 'id');
    }


    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function title(){
        return $this->belongsTo('App\Models\title', 'title_id', 'id');
    }

    public function identificationtype(){
        return $this->belongsTo('App\Models\identificationtype', 'identificationtype_id', 'id');
    }

    public function Statementservice(){
        return $this->belongsTo('App\Models\Statementservice', 'statementservice_id', 'id');
    }

    public function Employerstatus(){
        return $this->belongsTo('App\Models\Employerstatus', 'employerstatus_id', 'id');
    }

    public function Employerincomerange(){
        return $this->belongsTo('App\Models\Employerincomerange', 'employerincomerange_id', 'id');
    }

    public function modeofdeposite(){
        return $this->belongsTo('App\Models\modeofdeposite', 'modeofdeposite_id', 'id');
    }

    public function topups(){
        return $this->belongsTo('App\Models\topups', 'topups_id', 'id');
    }

    }




