<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;

class rptemployeeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
        
        date_default_timezone_set('asia/ho_chi_minh');
        $format = '';
        $now = date($format);
        $to = date($format, strtotime("+30 days"));
        $constraints = [
            'firstname' => $now,
            'staff_number' => $to
        ];


        $employee = $this->getfirstnameEmployee($constraints);
        return view('reports/rtpemployee/index', ['employees' => $employee, 'searchingVals' => $constraints]);
    }
    public function exportExcel(Request $request) {
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('reports/rtpemployee');
    }
    public function exportPDF(Request $request) {
         $constraints = [
            'firstname' => $request['firstname'],
            'staff_number' => $request['staff_number'],
        ];
        $employee = $this->getExportingData($constraints);
        $pdf = PDF::loadView('reports/rtpemployee/pdf', ['employees' => $employee, 'searchingVals' => $constraints]);
        return $pdf->download('report_from_'. $request['from'].'_to_'.$request['to'].'pdf');
        
    }
    
    private function prepareExportingData($request) {
        $author = Auth::user()->username;
        $employee = $this->getExportingData(['from'=> $request['from'], 'to' => $request['to']]);
        return Excel::create('report_from_'. $request['from'].'_to_'.$request['to'], function($excel) use($employee, $request, $author) {

        // Set the title
        $excel->setTitle('Employee details '. $request['from'].' to '. $request['to']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('SIC-FSL');

        // Call them separately
        $excel->setDescription('Employee details');

        $excel->sheet('Employee_Details', function($sheet) use($employees) {

        $sheet->fromArray($employee);
            });
        });
    }

    public function search(Request $request) {
        $constraints = [
            'firstname' => $request['firstname'],
            'staff_number' => $request['staff_number'],
        ];

        $employees = $this->getfirstnameEmployee($constraints);
        return view('reports/rtpemployee/index', ['employees' => $employees, 'searchingVals' => $constraints]);

        $employees = $this->getAllEmployee($constraints);
        return view('reports/rtpemployee/index', ['employees' => $employees, 'searchingVals' => $constraints]);
    }

    private function getfirstnameEmployee($constraints) {
        $employees = Employee::where('firstname', '=', $constraints['firstname'])
                        ->where('staff_number', '=', $constraints['staff_number'])

                        ->get();
        return $employees;

    }

    private function getExportingData($constraints) {
        return DB::table('employees')
        ->leftJoin('department', 'employees.department_id', '=', 'department.id')
        ->leftJoin('state', 'employees.state_id', '=', 'state.id')
        ->leftJoin('country', 'employees.country_id', '=', 'country.id')
        ->leftJoin('division', 'employees.division_id', '=', 'division.id')
        ->leftJoin('sexes', 'employees.sex_id', '=', 'sexes.id')
        ->leftJoin('fundtypes', 'employees.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('actives', 'employees.active_id', '=', 'actives.id')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.firstname as employee_name', 'employees.*','department.name as department_name', 'division.name as division_name', 'state_name as state_name', 'sex_type as sex_type', 'fundtype_name as fundtype_name', 'country_name as country_name', 'active_type as active_type', 'bank_name as bank_name')
        ->where('firstname', '=', $constraints['firstname'])
        ->where('staff_number', '<=', $constraints['staff_number'])
        ->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();
        }
        


    /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
         $path = storage_path().'/app/avatars/'.$name;
        if (file_exists($path)) {
            return Response::download($path);
        }
    }
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
