<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\client_contribution;
use App\Models\csv_data;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\Pictureupload;
use App\Models\Employee;


class preportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = auth()->user()->email;
        $clientaccount_number = '';
        $contribution_month = '';
        $constraints = [
            'clientaccount_number' => $clientaccount_number,
            'contribution_month' => $contribution_month,
        ];

        $client_contributions = $this->getmonthclient_contribution($constraints);
        return view('import/contribution-report/index', ['client_contribution' => $client_contributions, 'searchingVals' => $constraints]);
    }


    public function exportExcel(Request $request) {
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('import/contribution-report');
    }
    public function exportPDF(Request $request) {
         $constraints = [
            'clientaccount_number' => $request['clientaccount_number'],
            'contribution_month' => $request['contribution_month'],
        ];

        $pictureupload = Pictureupload::first();
        $employee = Employee::where('clientaccount_number', $request['clientaccount_number'])->first();

        $client_contributions = $this->getExportingData($constraints);
        $pdf = PDF::loadView('import/contribution-report/pdf', ['client_contribution' => $client_contributions, 'searchingVals' => $constraints, 'pictureuploads' => $pictureupload, 'employee' => $employee]);

        return $pdf->stream($request['contribution_month.pdf']);
        
    }
    
    private function prepareExportingData($request) {
        $author = Auth::user()->username;
        $client_contribution = $this->getExportingData(['from'=> $request['clientaccount_number'], 'to' => $request['contribution_month']]);
        return Excel::create('report_from_'. $request['clientaccount_number'].'_to_'.$request['contribution_month'], function($excel) use($client_contribution, $request, $author) {

        // Set the title
        $excel->setTitle('Individual Client Contributions for '. $request['clientaccount_number'].' to '. $request['contribution_month']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('Sic Brokerage Ltd');

        // Call them separately
        $excel->setDescription('Individual Client Contributions');

        $excel->sheet('Individual Client Contributions', function($sheet) use($client_contribution) {

        $sheet->fromArray($client_contribution);
            });
        });
    }

    public function search(Request $request) {
    $constraints = [
        'clientaccount_number' => $request['clientaccount_number'],
        'contribution_month' => $request['contribution_month'],
    ];

    $client_contributions = $this->getmonthclient_contribution($constraints);

    // Check if there are no client contributions
    if ($client_contributions->isEmpty()) {
        // Return view with a message indicating no data found
        return view('import/contribution-report/index')
            ->with(['client_contribution' => null, 'searchingVals' => $constraints, 'message' => 'No data found']);
    }

    // Return view with client contributions
    return view('import/contribution-report/index')
        ->with(['client_contribution' => $client_contributions, 'searchingVals' => $constraints]);
}

    private function getmonthclient_contribution($constraints) {
        $client_contributionobj = client_contribution::where('clientaccount_number', '=', $constraints['clientaccount_number'])
                        ->where('contribution_month', '=', $constraints['contribution_month']);
        if (auth()->user()->user_type !== 'admin') {
            $client_contributionobj->where('email',auth()->user()->email);
        }               
       $client_contributions = $client_contributionobj->get();
        return $client_contributions;

    }

    private function getExportingData($constraints) {
        $obj =  DB::table('client_contributions')
        ->select('client_contributions.clientaccount_number', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year') 
        ->where('clientaccount_number', '=', $constraints['clientaccount_number'])
        ->where('contribution_month', '=', $constraints['contribution_month']);
        
        if (auth()->user()->user_type !== 'admin') {
            $obj->where('email',auth()->user()->email);
        }               

       $client_contribution =  $obj->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

        return $client_contribution;

    }

}
