<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Employeeleave;
use Carbon\Carbon;




class leaveController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employeeleave = Employeeleave::all();
        $employeeleave = Employeeleave::paginate(5);
       return view('employee-leaves-details/employeeleaves/index', compact('employeeleave'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       $employeeleave = Employeeleave::all();
        return view('employee-leaves-details/employeeleaves/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, array(
            'employee_id' => 'required',
            'lastname' => 'required',
            'firstname' => 'required',
            'middlename' => 'required',
            'leave_days_approved' => 'required',
            'leave_days_carried_forward' => 'required',
            'leave_days_requested' => 'required',
           
        ));

        // calculate total leave days
        $total_leave_days = $request->leave_days_approved+$request->leave_days_carried_forward;

        // calculate outstanding leave days
        $outstanding_leave_days = $total_leave_days-$request->leave_days_requested;

        

        $employeeleave = new Employeeleave;

        $employeeleave->employee_id = $request->employee_id;
        $employeeleave->lastname = $request->lastname;
        $employeeleave->firstname = $request->firstname;
        $employeeleave->middlename = $request->middlename;
        $employeeleave->leave_days_approved = $request->leave_days_approved;
        $employeeleave->leave_days_carried_forward = $request->leave_days_carried_forward;
        $employeeleave->total_leave_days = $total_leave_days;
        $employeeleave->leave_days_requested = $request->leave_days_requested;
        $employeeleave->outstanding_leave_days = $outstanding_leave_days;

        $employeeleave->save();

        

        return redirect()->intended('employee-leaves-details/employeeleaves')->with('Success', 'Data Added Successfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
        //

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employeeleaves = Employeeleave::find($id);
       
        
        return view('employee-leaves-details/employeeleaves/edit',compact('employeeleaves','id'));
    }
        
        
    

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // calculate total leave days
        $total_leave_days = $request->leave_days_approved+$request->leave_days_carried_forward;

        // calculate outstanding leave days
        $outstanding_leave_days = $total_leave_days-$request->leave_days_requested;


        $employeeleave = Employeeleave::find($id);
        
        $employeeleave->employee_id = $request->get('employee_id');
        $employeeleave->firstname = $request->get('firstname');
        $employeeleave->middlename = $request->get('middlename');
        $employeeleave->lastname = $request->get('lastname');
        $employeeleave->leave_days_approved = $request->leave_days_approved;
        $employeeleave->leave_days_carried_forward = $request->leave_days_carried_forward;
        $employeeleave->total_leave_days = $total_leave_days;
        $employeeleave->leave_days_requested = $request->leave_days_requested;
        $employeeleave->outstanding_leave_days = $outstanding_leave_days;
        $employeeleave->save();

        return redirect('employee-leaves-details/employeeleaves')->with('success','Record update');
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $employeeleave = Employeeleave::find($id);
        $employeeleave->delete();
         return redirect('employee-leaves-details/employeeleaves')->with('success','Record deleted');
    /**
     * Search state from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    
    }

        public function search(Request $request) {
        $constraints = [
            'employee_id' => $request['employee_id'],
            'lastname' => $request['lastname'],
            'firstname' => $request['firstname'],
            'middlename' => $request['middlename'],
            'leave_days_approved' => $request['leave_days_approved'],
            'leave_days_carried_forward' => $request['leave_days_carried_forward'],
            'total_leave_days' => $request['total_leave_days'],
            'leave_days_requested' => $request['leave_days_requested'],
            'outstanding_leave_days' => $request['outstanding_leave_days'],
            ];
        $employeeleave = $this->doSearchingQuery($constraints);
        $constraints['firstname'];
        return view('employee-leaves-details/employeeleaves/index', ['employeeleave' => $employeeleave, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Employeeleave::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }

     /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
         $path = storage_path().'/app/avatars/'.$name;
        if (file_exists($path)) {
            return Response::download($path);
        }
    }

    private function validateInput($request) {
        $this->validate($request, [
            'employee_id' => 'required',
            'firstname' => 'required',
            'middlename' => 'required',
            'lastname' => 'required',
            'leave_days_approved' => 'required',
            'leave_days_carried_forward' => 'required',
            'total_leave_days' => 'required',
            'leave_days_requested' => 'required',
            'outstanding_leave_days' => 'required',
    ]);
    }

    private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }
}