<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\investmentknowledge;

class investmentknowledgeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $investmentknowledge = investmentknowledge::paginate(5);

        return view('system-mgmt/investmentknowledge/index', ['investmentknowledge' => $investmentknowledge]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/investmentknowledge/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         investmentknowledge::create([
            'investmentknowledge' => $request['investmentknowledge']
        ]);

        return redirect()->intended('system-management/investmentknowledge');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $investmentknowledges = investmentknowledge::find($id);
        return view('system-mgmt/investmentknowledge/edit', compact('investmentknowledges', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $investmentknowledge = investmentknowledge::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'investmentknowledge' => $request['investmentknowledge']
        ];
        investmentknowledge::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/investmentknowledge');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        investmentknowledge::where('id', $id)->delete();
         return redirect()->intended('system-management/investmentknowledge');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'investmentknowledge' => $request['investmentknowledge']
            ];

       $investmentknowledge = $this->doSearchingQuery($constraints);
       return view('system-mgmt/investmentknowledge/index', ['investmentknowledge' => $investmentknowledge, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = investmentknowledge::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'investmentknowledge' => 'required|max:120|unique:investmentknowledges'
    ]);
    }
}
