<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\interestday;

class interestdayController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $interestday = interestday::paginate(5);

        return view('asset-mgt/interestdaybasis/index', ['interestday' => $interestday]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('asset-mgt/interestdaybasis/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         $this->validateInput($request);
         interestday::create([
            'interestdaybasis' => $request['interestdaybasis']
        ]);

        return redirect()->intended('asset-mgt/interestdaybasis');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $interestdays = interestday::find($id);
        return view('asset-mgt/interestdaybasis/edit', compact('Interestdays', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $interestdays = interestday::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'interestdaybasis' => $request['interestdaybasis']
        ];
        interestday::where('id', $id)
            ->update($input);
        
        return redirect()->intended('asset-mgt/interestdaybasis')->with('success','Record update');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        interestday::where('id', $id)->delete();
         return redirect()->intended('asset-mgt/interestdaybasis');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'interestdaybasis' => $request['interestdaybasis']
            ];

       $interestday = $this->doSearchingQuery($constraints);
       return view('asset-mgt/interestdaybasis/index', ['interestday' => $interestday, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = interestday::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'interestdaybasis' => 'required|max:60|unique:interestdays'
    ]);
    }
}
