<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Withdrawalform;
use App\Models\reasonforwithdrawal;

class WithdrawalformController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $withdrawalform = DB::table('withdrawalforms')

        ->leftJoin('reasonforwithdrawals', 'withdrawalforms.reasonforwithdrawal_id', '=', 'reasonforwithdrawals.id')
        ->leftJoin('accounttypes', 'withdrawalforms.accounttype_id', '=', 'accounttypes.id')
        ->leftJoin('fundtypes', 'withdrawalforms.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('paymentoptions', 'withdrawalforms.paymentoptions_id', '=', 'paymentoptions.id')


        ->select('withdrawalforms.*', 'sex_type as sex_type', 'sexes.id as sex_id', 'active_type as active_type', 'actives.id as active_id', 'fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'paymentoption as paymentoption', 'paymentoptions.id as paymentoptions_id')


        ->orderBy('active_type', 'desc')
        ->orderBy('created_at', 'asc')
        ->paginate(10);


        return view('withdrawalform/index', ['withdrawalform' => $withdrawalform]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
