<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\withdrawal;

class WithdrawalController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $withdrawal = withdrawal::paginate(5);

        return view('system-mgmt/withdrawal/index', ['withdrawal' => $withdrawal]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/withdrawal/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         withdrawal::create([
            'withdrawal' => $request['withdrawal']
        ]);

        return redirect()->intended('system-management/withdrawal');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $withdrawal = withdrawal::find($id);
        return view('system-mgmt/withdrawal/edit', compact('withdrawal', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $withdrawals = withdrawal::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'withdrawal' => $request['withdrawal']
        ];
        withdrawal::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/withdrawal');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        withdrawal::where('id', $id)->delete();
         return redirect()->intended('system-management/withdrawal');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'topup' => $request['topup']
            ];

       $topup = $this->doSearchingQuery($constraints);
       return view('system-mgmt/topup/index', ['topup' => $topup, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = withdrawal::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'withdrawal' => 'required|max:120|unique:withdrawals'
    ]);
    }
}
