<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Transaction;

class TransactionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Transaction = Transaction::paginate(5);

        return view('system-mgmt/transaction/index', ['Transaction' => $Transaction]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         return view('system-mgmt/transaction/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, array(
            'transaction_type' => 'required',
            ));

        $Transaction = new Transaction;

        $Transaction->transaction_type = $request->transaction_type;

        $Transaction->save();

        return redirect()->intended('system-management/transaction')->with('Success', 'Data Added Successfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Transactions = Transaction::find($id);
        
            return view('system-mgmt/transaction/edit', compact('Transactions', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $Transactions = Transaction::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'transaction_type' => $request['transaction_type']
        ];
        Transaction::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/transaction');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Transaction::where('id', $id)->delete();
         return redirect()->intended('system-management/transaction');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'transaction_type' => $request['transaction_type']
            ];

       $Transaction = $this->doSearchingQuery($constraints);
       return view('system-mgmt/transaction/index', ['Transaction' => $Transaction, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Transaction::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
}

    private function validateInput($request) {
        $this->validate($request, [
        'transaction_type' => 'required|unique:transactions'
    ]);
    }
}
