<?php

namespace App\Http\Controllers;

use App\studentnextofkin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\studentkyc;

class StudentnextofkinController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($stdId)
    {
        $studentkyc = studentkyc::find($stdId);
        $studentnextofkin = studentnextofkin::all();
        $studentnextofkin = studentnextofkin::paginate(5);
       return view('other-employee-details/studentnextofkin/index')->with(['studentnextofkin' => $studentnextofkin, 'studentkyc' => $studentkyc]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $studentnextofkin = studentnextofkin::all();
        return view('other-employee-details/studentnextofkin/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, array(
            'clients_name' => 'required',
            'name_of_beneficiary_1' => 'required',
            'relationship_1' => 'required',
            'contact_1' => 'required',
            'name_of_beneficiary_2' => 'required',
            'relationship_2' => 'required',
            'contact_2' => 'required',
            'name_of_beneficiary_3' => 'required',
            'relationship_3' => 'required',
            'contact_3' => 'required',
            'name_of_beneficiary_4' => 'required',
            'relationship_4' => 'required',
            'contact_4' => 'required',
            'name_of_beneficiary_5' => 'required',
            'relationship_5' => 'required',
            'contact_5' => 'required',
           

        ));

        $studentnextofkin = new studentnextofkin;

        $studentnextofkin->clients_name = $request->clients_name;
        $studentnextofkin->name_of_beneficiary_1 = $request->name_of_beneficiary_1;
        $studentnextofkin->relationship_1 = $request->relationship_1;
        $studentnextofkin->contact_1 = $request->contact_1;
        $studentnextofkin->name_of_beneficiary_2 = $request->name_of_beneficiary_2;
        $studentnextofkin->relationship_2 = $request->relationship_2;
        $studentnextofkin->contact_2 = $request->contact_2;
        $studentnextofkin->name_of_beneficiary_3 = $request->name_of_beneficiary_3;
        $studentnextofkin->relationship_3 = $request->relationship_3;
        $studentnextofkin->contact_3 = $request->contact_3;
        $studentnextofkin->name_of_beneficiary_4 = $request->name_of_beneficiary_4;
        $studentnextofkin->relationship_4 = $request->relationship_4;
        $studentnextofkin->contact_4 = $request->contact_4;
        $studentnextofkin->name_of_beneficiary_5 = $request->name_of_beneficiary_5;
        $studentnextofkin->relationship_5 = $request->relationship_5;
        $studentnextofkin->contact_5 = $request->contact_5;
        

        $post->save();

        

        return redirect()->intended('/other-employee-details/studentnextofkin');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\studentnextofkin  $studentnextofkin
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\studentnextofkin  $studentnextofkin
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $studentnextofkins = studentnextofkin::find($id);
        return view('other-employee-details/studentnextofkin/edit', compact('studentnextofkins', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\studentnextofkin  $studentnextofkin
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, studentnextofkin $studentnextofkin)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\studentnextofkin  $studentnextofkin
     * @return \Illuminate\Http\Response
     */
    public function destroy(studentnextofkin $studentnextofkin)
    {
        //
    }

    /**
     * Search department from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
       $constraints = [
            
            'name_of_beneficiary_1' => $request['name_of_beneficiary_1'],
            'relationship_1' => $request['relationship_1'],
            'contact_1' => $request['contact_1'],
            'name_of_beneficiary_2' => $request['name_of_beneficiary_2'],
            'relationship_2' => $request['relationship_2'],
            'contact_2' => $request['contact_2'],
            'name_of_beneficiary_3' => $request['name_of_beneficiary_3'],
            'relationship_3' => $request['relationship_3'],
            'contact_3' => $request['contact_3'],
            'name_of_beneficiary_4' => $request['name_of_beneficiary_4'],
            'relationship_4' => $request['relationship_4'],
            'contact_4' => $request['contact_4'],
            'name_of_beneficiary_5' => $request['name_of_beneficiary_5'],
            'relationship_5' => $request['relationship_5'],
            'contact_5' => $request['contact_5'],
            ];
        $studentkycs = $this->doSearchingQuery($constraints);
        $constraints = [
            'firstname' => $request['firstname'],];
        return view('other-employee-details/studentnextofkin/index', ['studentkycs' => $studentkycs, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = studentkyc::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
    
    ]);
    }
}
