<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\studentkyc;
use App\Models\State;
use App\Models\Country;
use App\Models\maritalstatus;
use App\Models\sex;
use App\Models\accounttype;
use App\Models\active;
use Carbon\Carbon;
use App\Models\bank;
use App\Models\investmenttframe;
use Illuminate\Support\Facades\Storage;
use App\Models\feedback;
use App\Models\identificationtype;
use App\Models\sourceoffunds;
use App\Models\residentialstatus;
use App\Models\City;
use App\Models\Statementservice;
use App\Models\Statementfrequency;
use App\Models\Employerincomerange;
use App\Models\Employerstatus;
use App\Models\fundtype;
use App\Models\title;
use App\Models\User;
use App\Models\Countryresidence;
use App\Models\risktolerance;
use App\Models\investmentknowledge;
use App\Models\modeofaccount;
use App\Models\modeofdeposite;
use App\Models\topups;
use App\Models\withdrawal;
use App\Models\Employee;

class StudentkycController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $studentkyc = DB::table('studentkycs')
       
        ->leftJoin('country', 'studentkycs.country_id', '=', 'country.id')
        ->leftJoin('maritalstatuses', 'studentkycs.maritalstatus_id', '=', 'maritalstatuses.id')
        ->leftJoin('sexes', 'studentkycs.sex_id', '=', 'sexes.id')
        ->leftJoin('accounttypes', 'studentkycs.accounttype_id', '=', 'accounttypes.id')
        ->leftJoin('actives', 'studentkycs.active_id', '=', 'actives.id')
        ->leftjoin('identificationtypes', 'studentkycs.identificationtype_id', '=', 'identificationtypes.id')
        ->leftjoin('residentialstatuses', 'studentkycs.residentialstatus_id', '=', 'residentialstatuses.id')
        ->leftJoin('fundtypes', 'studentkycs.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('titles', 'studentkycs.title_id', '=', 'titles.id')
        ->leftjoin('users', 'studentkycs.user_id', '=', 'users.id')
        ->select('studentkycs.*', 'maritalstatus_type as maritalstatus_type', 'maritalstatuses.id as maritalstatus_id', 'active_type as active_type', 'actives.id as active_id','sex_type as sex_type', 'sexes.id as sex_id', 'account_type as account_type', 'accounttypes.id as accounttype_id', 'country_name as country_name', 'country.id as country_id', 'identification_type as identification_type', 'identificationtypes.id as identificationtype_id', 'residential_type as residential_type', 'residentialstatuses.id as residentialstatus_id', 'fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'title_name as title_name', 'titles.id as title_id', 'users.id as user_id')
        ->orderBy('active_type', 'desc')
        ->orderBy('created_at', 'asc')
        ->paginate(10);


        return view('studentkyc/index', ['studentkyc' => $studentkyc]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = auth()->user();

    // If the user is admin, fetch all users' forms
    if ($user->user_type == 'admin') {
        $studentkyc = studentkyc::all();
    } else {
        // If the user is not admin, fetch only their own forms
        $studentkyc = $user->studentkycs;
    }

    $countries = Country::all();
    $maritalstatus = maritalstatus::all();
    $sex = sex::all();
    $accounttype = accounttype::all();
    $active = active::all();
    $identificationtype = identificationtype::all();
    $residentialstatus = residentialstatus::all();
    $fundtype = fundtype::all();
    $title = title::all();
    
    return view('studentkyc/create', [
        'countries' => $countries,
        'maritalstatus' => $maritalstatus,
        'sex' => $sex,
        'accounttype' => $accounttype,
        'active' => $active,
        'identificationtype' => $identificationtype,
        'residentialstatus' => $residentialstatus,
        'fundtype' => $fundtype,
        'title' => $title,
        'studentkyc' => $studentkyc, // Pass the fetched studentkyc to the view
        
    ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Define a default value for active_id
    $defaultActiveId = 0; // Adjust this value based on your application's logic
    
          //$this->validateInput($request);
       $age = Carbon::parse($request->birthdate)->age;
       $request->request->add(['age' => $age]);

        $imagePath = null;
        $imagePath1 = null;
        $imagePath2 = null;
        // Upload image

        if ($request->hasFile('passportpicture_img')) {
            $imagePath = Storage::putFile('avatars', $request->file('passportpicture_img'));
        }

        if ($request->hasFile('pictureID_img')) {
            $imagePath1 = Storage::putFile('avatars', $request->file('pictureID_img'));
        }

        if ($request->hasFile('signature_upload_img')) {
            $imagePath2 = Storage::putFile('avatars', $request->file('signature_upload_img'));
        }



        $request->merge(['passportpicture' => $imagePath ]);
        $request->merge(['pictureID' => $imagePath1]);
        $request->merge(['signature_upload' => $imagePath2]);


        $keys = ['clientaccount_number', 'passportpicture', 'pictureID', 'signature_upload', 'lastname', 'firstname', 'middlename', 'fundtype_id', 'country_id', 'sex_id', 'accounttype_id', 'title_id', 'birthdate', 'age', 'identificationtype_id', 'maritalstatus_id', 'residentialstatus_id', 'phone_number', 'mobile_number', 'email_address_contact', 'digital_address_contact', 'identification_number', 'postal_address', 'residential_address', 'residential_permit', 'permit_issue_date', 'place_of_issue_of_permit', 'permit_expiry_date', 'ID_issue_date', 'ID_place_of_issue', 'ID_expiry_date', 'name_of_beneficiary_1', 'relationship_1', 'contact_1', 'name_of_beneficiary_2', 'relationship_2', 'contact_2', 'name_of_beneficiary_3', 'relationship_3', 'contact_3', 'name_of_beneficiary_4', 'relationship_4', 'contact_4', 'name_of_beneficiary_5', 'relationship_5', 'contact_5', 'active_id', 'user_id'
            
        ];

// Create employee
    $studentkyc = studentkyc::create($request->all());

    // Retrieve the logged-in user
    $user = auth()->user();

    // Check if the user exists and has a clientaccount_number
    if ($user && $user->clientaccount_number) {
        // Update the studentkyc's clientaccount_number with the user's clientaccount_number
        $studentkyc->update(['clientaccount_number' => $user->clientaccount_number]);
    }

    // Create employee
    

    // Construct SMS message
       $message = "Hi ".$studentkyc->firstname.",\nThanks for registering a student investment account with SIC-FSL.Your account number is ".$studentkyc->clientaccount_number.".Dial *789*3*658# with your account number as reference to make your initial and subsequent contributions. WhatsApp 0509541184, call 0302767051 for further info.
           \nSIC-FSL";

      $key = "OE3GjyUpBzVaWOVDXRHLapjO0"; // 0244234015 API Key 
            $to = $studentkyc->mobile_number;  // phone number to send sms to
            $msg = $message;   // actual message to deliver
            $sender_id = "SIC-FSL";   //sender_id: 11 mine

            //encode the message
            $msg = urlencode($msg);

            // prepare the url & endpoint
            $url = "https://apps.mnotify.net/smsapi?"
                        . "key=$key"
                        . "&to=$to"
                        . "&msg=$msg"
                        . "&sender_id=$sender_id";

            $response = file_get_contents($url);   // get message response
            echo $response; echo "<br>";

             //decode response
             $decoded_response = json_decode($response);
             if($decoded_response->code  == '1000'){
                echo "sms_sent"; echo "<br>";

                 }else{
                     echo "sms_error";
                     echo $decoded_response->code;
                }



    // Determine the redirection based on user type
    $redirectPath = $user->user_type == 'admin' ? '/studentkyc' : '/dashboard';
    


    // Redirect with success message
    return redirect($redirectPath)->with('success', 'Data Added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $studentkyc = studentkyc::where('clientaccount_number', auth()->user()->clientaccount_number)->first();
        

    $title = title::all();
    $active = active::all();
    $sex = sex::all();
    $studentkyc = studentkyc::all();
    $residentialstatus = residentialstatus::all();
    $identificationtype = identificationtype::all();

    return view('studentkyc.show', compact('studentkyc', 'active', 'sex', 'title', 'residentialstatus', 'identificationtype'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $studentkycs = studentkyc::find($id);
        // Redirect to state list if updating state wasn't existed
        if ($studentkycs == null) {
            return redirect()->intended('/studentkyc');
        }
        $countries = Country::all();
    $maritalstatus = maritalstatus::all();
    $sex = sex::all();
    $accounttype = accounttype::all();
    $active = active::all();
    $identificationtype = identificationtype::all();
    $residentialstatus = residentialstatus::all();
    $fundtype = fundtype::all();
    $title = title::all();
    $countryresidence = Countryresidence::all();


        return view('studentkyc/edit', ['studentkycs' => $studentkycs, 'countries' => $countries,
        'maritalstatus' => $maritalstatus,
        'sex' => $sex,
        'accounttype' => $accounttype,
        'active' => $active,
        'identificationtype' => $identificationtype,
        'residentialstatus' => $residentialstatus,
        'fundtype' => $fundtype,
        'title' => $title ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
{
    $studentkyc = Studentkyc::findOrFail($id);
    $this->validateInput($request);
    
    // Calculate age
    $age = Carbon::parse($request->birthdate)->age;
    $request->merge(['age' => $age]);

    // Handle image uploads
    $imagePath = $studentkyc->passportpicture;
    $imagePath1 = $studentkyc->pictureID;
    $imagePath2 = $studentkyc->signature_upload;

    if ($request->hasFile('passportpicture_img')) {
        $imagePath = Storage::putFile('avatars', $request->file('passportpicture_img'));
    }
    if ($request->hasFile('pictureID_img')) {
        $imagePath1 = Storage::putFile('avatars', $request->file('pictureID_img'));
    }
    if ($request->hasFile('signature_upload_img')) {
        $imagePath2 = Storage::putFile('avatars', $request->file('signature_upload_img'));
    }

    // Merge image paths into request
    $request->merge(['passportpicture' => $imagePath]);
    $request->merge(['pictureID' => $imagePath1]);
    $request->merge(['signature_upload' => $imagePath2]);

    // Update studentkyc record
    $studentkyc->update($request->all());

    // Retrieve associated employee record
    $employee = Employee::where('clientaccount_number', $studentkyc->clientaccount_number)->first();

    // If employee exists, update its data
    if ($employee) {
        $employee->update($request->all());
    }

    // Redirect with success message
    return redirect()->intended('/studentkyc')->with('success', 'Record Updated Successfully');
}

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        studentkyc::where('id', $id)->delete();
         return redirect()->intended('/studentkyc')->with('success', 'Record Deleted Sucessfuly');
    }

    /**
     * Search state from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'firstname' => $request['firstname'],
            'clientaccount_number' => $request['clientaccount_number']
            ];
        $studentkyc = $this->doSearchingQuery($constraints);

        return view('studentkyc/index', ['studentkyc' => $studentkyc, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = DB::table('studentkycs')
        
        ->leftJoin('country', 'studentkycs.country_id', '=', 'country.id')
        ->leftJoin('maritalstatuses', 'studentkycs.maritalstatus_id', '=', 'maritalstatuses.id')
        ->leftJoin('sexes', 'studentkycs.sex_id', '=', 'sexes.id')
        ->leftJoin('accounttypes', 'studentkycs.accounttype_id', '=', 'accounttypes.id')
        ->leftJoin('actives', 'studentkycs.active_id', '=', 'actives.id')
        ->leftjoin('identificationtypes', 'studentkycs.identificationtype_id', '=', 'identificationtypes.id')
        ->leftjoin('residentialstatuses', 'studentkycs.residentialstatus_id', '=', 'residentialstatuses.id')
        ->leftJoin('fundtypes', 'studentkycs.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('titles', 'studentkycs.title_id', '=', 'titles.id')
        ->leftjoin('users', 'studentkycs.user_id', '=', 'users.id')
        ->select('studentkycs.*', 'maritalstatus_type as maritalstatus_type', 'maritalstatuses.id as maritalstatus_id', 'active_type as active_type', 'actives.id as active_id','sex_type as sex_type', 'sexes.id as sex_id', 'account_type as account_type', 'accounttypes.id as accounttype_id', 'country_name as country_name', 'country.id as country_id', 'identification_type as identification_type', 'identificationtypes.id as identificationtype_id', 'residential_type as residential_type', 'residentialstatuses.id as residentialstatus_id', 'fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'title_name as title_name', 'titles.id as title_id', 'users.id as user_id');

        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $field => $constraint) {
    if ($constraint != null) {
        // Assuming 'firstname' belongs to the 'employees' table
        $query = $query->where('studentkycs.' . $field, 'like', '%' . $constraint . '%');
    }
}

            $index++;
        
        return $query->paginate(100);
    }

     /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
        $imagePath = storage_path().'/app/avatars/'.$name;
        if (file_exists($imagePath)) {
            return Response::download($imagePath);
        }

         $imagePath1 = storage_path().'../app/pictureID/'.$name;
        if (file_exists($imagePath1)) {
            return Response::download($imagePath1);
        }

        $imagePath2 = storage_path().'../app/signature_upload/'.$name;
        if (file_exists($imagePath1)) {
            return Response::download($imagePath1);
        }


}

   /**
     * @param Request $request
     *
     * @return string
     */

        public function approveDisapproveLeave($id, $active)
    {
       return 'here';
      $employeeId = $id;


       $employee = Employee::where('id', $employeeId)->first();

      $employee->update(['active' => $active]);

      return back()->with('success', 'Client Activated');

}


private function validateInput($request) {
        $this->validate($request, [
            'clientaccount_number' => 'nullable',
            'passportpicture' => 'nullable',
            'pictureID' => 'nullable', 
            'signature_upload' => 'nullable', 
            'lastname' => 'nullable',
            'firstname' => 'nullable',  
            'middlename' => 'nullable', 
            'fundtype_id' => 'nullable', 
            'country_id' => 'nullable',   
            'sex_id' => 'nullable', 
            'accounttype_id' => 'nullable', 
            'title_id' => 'nullable', 
            'birthdate' => 'nullable', 
            'age'=> 'nullable',  
            'identificationtype_id' => 'nullable', 
            'maritalstatus_id' => 'nullable', 
            'residentialstatus_id' => 'nullable', 
            'phone_number' => 'nullable', 
            'mobile_number' => 'nullable', 
            'email_address_contact' => 'nullable', 
            'digital_address_contact' => 'nullable',
            'identification_number' => 'nullable', 
            'postal_address' => 'nullable', 
            'residential_address' => 'nullable', 
            'residential_permit' => 'nullable', 
            'permit_issue_date' => 'nullable', 
            'place_of_issue_of_permit' => 'nullable', 
            'permit_expiry_date' => 'nullable', 
            'ID_issue_date' => 'nullable', 
            'ID_place_of_issue' => 'nullable', 
            'ID_expiry_date' => 'nullable', 
            'name_of_beneficiary_1' => 'nullable', 
            'relationship_1' => 'nullable', 
            'contact_1' => 'nullable', 
            'name_of_beneficiary_2' => 'nullable', 
            'relationship_2' => 'nullable', 
            'contact_2' => 'nullable', 
            'name_of_beneficiary_3' => 'nullable', 
            'relationship_3' => 'nullable', 
            'contact_3' => 'nullable', 
            'name_of_beneficiary_4' => 'nullable', 
            'relationship_4' => 'nullable', 
            'contact_4' => 'nullable', 
            'name_of_beneficiary_5' => 'nullable', 
            'relationship_5' => 'nullable', 
            'contact_5' => 'nullable', 
            'active_id' => 'nullable', 

    ]);


    }
    private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }

}
