<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Employee;
use App\Models\State;
use App\Models\Country;
use App\Models\maritalstatus;
use App\Models\sex;
use App\Models\accounttype;
use App\Models\active;
use Carbon\Carbon;
use App\Models\bank;
use App\Models\investmenttframe;
use Illuminate\Support\Facades\Storage;
use App\Models\feedback;
use App\Models\identificationtype;
use App\Models\sourceoffunds;
use App\Models\residentialstatus;
use App\Models\City;
use App\Models\Statementservice;
use App\Models\Statementfrequency;
use App\Models\Employerincomerange;
use App\Models\Employerstatus;
use App\Models\fundtype;
use App\Models\title;
use App\Models\User;
use App\Models\Countryresidence;
use App\Models\risktolerance;
use App\Models\investmentknowledge;
use App\Models\modeofaccount;
use App\Models\modeofdeposite;
use App\Models\topups;
use App\Models\withdrawal;
use App\Models\client_contribution;
use App\Models\studentkyc;



class StatisticsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$total_clients = Employee::all()->count();
        
         $sex = sex::all();
        $active = active::all();
        $accounttype = accounttype::all();
        $fundtype = fundtype::all();
        $studentkyc = DB::table('studentkycs')
        ->leftJoin('actives', 'studentkycs.active_id', '=', 'actives.id')
        ->leftJoin('sexes', 'studentkycs.sex_id', '=', 'sexes.id')
        ->leftJoin('accounttypes', 'studentkycs.accounttype_id', '=', 'accounttypes.id')
        ->leftJoin('fundtypes', 'studentkycs.fundtype_id', '=', 'fundtypes.id')
        ->select('studentkycs.*', 'active_type as active_type', 'actives.id as active_id', 'sex_type as sex_type', 'sexes.id as sex_id', 'account_type as account_type', 'fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id')
        ->where('active_id', '=', '0')
        ->get();
    
        
        $client_contribution = client_contribution::sum('contribution_amount');
        $fundtype1 = studentkyc::where('fundtype_id', '=', '1')
        ->where('active_id', '=', '2')->count();
        $fundtype2 = studentkyc::where('fundtype_id', '=', '2')
        ->where('active_id', '=', '2')->count();
        $fundtype3 = studentkyc::where('fundtype_id', '=', '3')
        ->where('active_id', '=', '2')->count();
        $fundtype4 = studentkyc::where('fundtype_id', '=', '4')
        ->where('active_id', '=', '2')->count();
        $fundtype5 = studentkyc::where('fundtype_id', '=', '5')
        ->where('active_id', '=', '2')->count();
        $fundtype6 = studentkyc::where('fundtype_id', '=', '6')
        ->where('active_id', '=', '2')->count();
        $fundtype7 = studentkyc::where('fundtype_id', '=', '7')
        ->where('active_id', '=', '2')->count();
        $fundtype8 = studentkyc::where('fundtype_id', '=', '8')
        ->where('active_id', '=', '2')->count();
        
       
        //return 'hello world';
        // // fetch total contribution

        //$total_clients = Employee::where('id', '=', $fundtype)->get();
        //$wordCount = $wordlist->count();

        $total_clients = studentkyc::where('active_id', '=', '2')->count();
        
        $total_Nullclients = studentkyc::where('active_id', '=', '0')->count();

        
        
        return view('statistics/index')->with([
             'total_clients' =>  $total_clients,
            'total_contributions' => 0,
             'total_Nullclients' => 0, 'total_Nullclients' => $total_Nullclients,
             'total_contributions' => 0, 'client_contribution' => $client_contribution,
             'fundtype1' => 0, 'fundtype1' => $fundtype1,
             'fundtype2' => 0, 'fundtype2' => $fundtype2,
             'fundtype3' => 0, 'fundtype3' => $fundtype3,
             'fundtype4' => 0, 'fundtype4' => $fundtype4,
             'fundtype5' => 0, 'fundtype5' => $fundtype5,
             'fundtype6' => 0, 'fundtype6' => $fundtype6,
             'fundtype7' => 0, 'fundtype7' => $fundtype7,
             'fundtype8' => 0, 'fundtype8' => $fundtype8,
             'studentkyc' => $studentkyc, 'active' => $active, 'sex' => $sex, 'fundtype' => $fundtype ]);
    }

    

    
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
