<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Statementservice;

class StatementserviceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $statementservice = Statementservice::paginate(5);

        return view('system-mgmt/statementservice/index', ['statementservice' => $statementservice]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/statementservice/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         Statementservice::create([
            'statementservice_type' => $request['statementservice_type']
        ]);

        return redirect()->intended('system-management/statementservice');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $statementservices = Statementservice::find($id);
        return view('system-mgmt/statementservice/edit', compact('statementservices', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $statementservice = Statementservice::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'statementservice_type' => $request['statementservice_type']
        ];
        Statementservice::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/statementservice');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Statementservice::where('id', $id)->delete();
         return redirect()->intended('system-management/statementservice');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'statementservice_type' => $request['statementservice_type']
            ];

       $statementservice = $this->doSearchingQuery($constraints);
       return view('system-mgmt/statementservice/index', ['statementservice' => $statementservice, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Statementservice::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'statementservice_type' => 'required|max:120|unique:statementservices'
    ]);
    }
}
