<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\sourceoffunds;

class SourceoffundsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sourceoffunds = sourceoffunds::paginate(5);

        return view('system-mgmt/sourceoffund/index', ['sourceoffunds' => $sourceoffunds]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/sourceoffund/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         sourceoffunds::create([
            'source_type' => $request['source_type']
        ]);

        return redirect()->intended('system-management/sourceoffund');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sourceoffunds = sourceoffunds::find($id);
        return view('system-mgmt/sourceoffund/edit', compact('sourceoffunds', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $sourceoffund = sourceoffunds::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'source_type' => $request['source_type']
        ];
        sourceoffunds::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/sourceoffund');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        sourceoffunds::where('id', $id)->delete();
         return redirect()->intended('system-management/sourceoffund');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'source_type' => $request['source_type']
            ];

       $sourceoffund = $this->doSearchingQuery($constraints);
       return view('system-mgmt/sourceoffund/index', ['sourceoffund' => $sourceoffund, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = sourceoffunds::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'source_type' => 'required|max:120|unique:sourceoffunds'
    ]);
    }
}
