<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\client_contribution;
use App\Models\Employee;
use App\Models\sex;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\Pictureupload; 
use App\Models\singleclientrpt;

class SingleclientrptController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index()
    {
       // Get the currently authenticated client
    $user = Auth::user();

    // Retrieve the client's contributions
    $client_contribution = client_contribution::where('clientaccount_number', $user->clientaccount_number)->get();

    // Calculate the sum of contribution_amount
    $total = $client_contribution->sum('contribution_amount');

    // Pass contributions data and total contribution to the view
    return view('import/singleclient-report/index', [
        'client_contribution' => $client_contribution,
        'total' => $total
    ]);
    }

public function exportPDF()
{
    // Get the currently authenticated client
    $user = Auth::user();

    // Retrieve the client's contributions
    $client_contribution = client_contribution::where('clientaccount_number', $user->clientaccount_number)->get();

    $pictureupload = Pictureupload::first();
    $employee = Employee::where('clientaccount_number', $user->clientaccount_number)->first();

    // Calculate the sum of contribution_amount
    $total = $client_contribution->sum('contribution_amount');

    // Load the PDF view
    $pdf = PDF::loadView('import.singleclient-report.pdf', [
        'client_contribution' => $client_contribution,
        'total' => $total, 'pictureuploads' => $pictureupload, 'employee' => $employee
    ]);

    // Return the PDF for streaming or download
    return $pdf->stream('singleclient_report.pdf');
}

    
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
