<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\sex;

class SexController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sex = sex::paginate(5);

        return view('system-mgmt/sex/index', ['sex' => $sex]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        return view('system-mgmt/sex/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         sex::create([
            'sex_type' => $request['sex_type']
        ]);

        return redirect()->intended('system-management/sex');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sexs = sex::find($id);
        return view('system-mgmt/sex/edit', compact('sexs', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $sexs = sex::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'sex_type' => $request['sex_type']
        ];
        sex::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/sex');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        sex::where('id', $id)->delete();
         return redirect()->intended('system-management/sex');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'sex_type' => $request['sex_type']
            ];

       $sex = $this->doSearchingQuery($constraints);
       return view('system-mgmt/sex/index', ['sex' => $sex, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = sex::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'sex_type' => 'required|max:60|unique:sexes'
    ]);
    }
}
