<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\risktolerance;

class RisktoleranceController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $risktolerance = risktolerance::paginate(5);

        return view('system-mgmt/risktolerance/index', ['risktolerance' => $risktolerance]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/risktolerance/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         $this->validateInput($request);
         risktolerance::create([
            'risktolerance' => $request['risktolerance']
        ]);

        return redirect()->intended('system-management/risktolerance');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $risktolerance = risktolerance::find($id);
        return view('system-mgmt/risktolerance/edit', compact('risktolerance', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $risktolerances = risktolerance::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'risktolerance' => $request['risktolerance']
        ];
        risktolerance::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/risktolerance');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        risktolerance::where('id', $id)->delete();
         return redirect()->intended('system-management/risktolerance');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'risktolerance' => $request['risktolerance']
            ];

       $risktolerance = $this->doSearchingQuery($constraints);
       return view('system-mgmt/risktolerance/index', ['risktolerance' => $risktolerance, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = risktolerance::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'risktolerance' => 'required|max:120|unique:risktolerances'
    ]);
    }
}
