<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Employee;
use App\ClaimType;
use App\Retirement_death;
use App\client_contribution;
use App\interest;

class Retirement_deathController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $employees = Employee::all();
        $Retirement_death = DB::table('retirement_deaths')
        ->leftJoin('claim_types', 'retirement_deaths.claimtype_id', '=', 'claim_types.id')
        ->leftJoin('interests', 'retirement_deaths.interests_id', '=', 'interests.id')
        ->select('retirement_deaths.*', 'claim_types.claimtype_name as claimtype_name', 'claim_types.id as claimtype_id', 'interests.interest_amount as interest_amount', 'interests.id as interests_id')
        ->paginate(5);


        //return  ['Retirement_death' => $Retirement_death];

        return view('retirement-death/index', ['Retirement_death' => $Retirement_death]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $Retirement_death = Retirement_death::all();
        return view('retirement-death/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // balance amount calculation

       //$balance_amount = $request['total_contribution']-$request['approved_claim_amount'];



        //$created = Retirement_death::create([
            //'staff_no' => $request['staff_number'],
            //'name' => $request['name'],
            //'claimtype_id' => $request['claimtype_id'],
            //'incident_date' => $request['incident_date'],
            //'total_contribution' => $request['sum'],
            //'approved_claim_amount' => $request['approved_claim_amount'],
            //'balance_amount' => $request['balance_amount'],
            //'comment' => $request['comment']
       //]);



        //return redirect('retirement-death');

        //$this->validate($request, array(
           // 'staff_no' => 'required',
            //'name' => 'required',
            //'claimtype_id' => 'required',
            //'incident_date' => 'required',
            //'total_contribution' => 'required',
            //'approved_claim_amount' => 'required',
            //'balance_amount' => 'required',
            //'comment' => 'required'
        //));

       // calculate balance amount
        $balance_amount = $request->sum-$request->tc_dot_amount;

        $interestRecord = interest::find($request->interests_id);
        // calculate benefit amount
        $benefit_amount = $request->sum * $interestRecord->interest_amount;

        $Retirement_death = new Retirement_death;

        $Retirement_death->staff_no = $request->staff_number;
        $Retirement_death->name = $request->name;
        $Retirement_death->claimtype_id = $request->claimtype_id;
        $Retirement_death->interests_id = $request->interests_id;
        $Retirement_death->incident_date = $request->incident_date;
        $Retirement_death->amount_paid = $request->amount_paid;
        $Retirement_death->total_contribution = $request->sum;
        $Retirement_death->tc_dot_amount = $request->tc_dot_amount;
        $Retirement_death->benefit_amount = $benefit_amount;
        $Retirement_death->comment = $request->comment;
        $Retirement_death->balance_amount = $balance_amount;



        $Retirement_death->save();

        
        $employee = Employee::where('staff_number', $request->get('staff_number'))->first();
        $employee->active_id = 2; // active type 2 means no more active
        $employee->save();


        return redirect('retirement-death')->with('success','Data Saved Successful');


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Retirement_death = Retirement_death::find($id);
        // Redirect to state list if updating state wasn't existed
        if ($Retirement_death == null) {
            return redirect()->intended('/retirement-death');
        }
        $ClaimTypes = ClaimType::all();
        $interest = interest::all();
        return view('retirement-death/edit', ['Retirement_death' => $Retirement_death, 'ClaimTypes' => $ClaimTypes, 'interest' => $interest])->with('success','Record update');
}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // total amount calculation

        $balance_amount = $request->total_contribution-$request->tc_dot_amount;

        $interestRecord = interest::find($request->interests_id);
        // calculate benefit amount
        $benefit_amount = $request->total_contribution * $interestRecord->interest_amount;

        //$Retirement_death = Retirement_death::findOrFail($id);
        //$input = [
            //'staff_no' => $request['staff_no'],
            //'name' => $request['name'],
            //'claimtype_id' => $request['claimtype_id'],
            //'incident_date' => $request['incident_date'],
            //'total_contribution' => $request['sum'],
            //'approved_claim_amount' => $request['approved_claim_amount'],
            //'balance_amount' => $request['balance_amount'],
            //'comment' => $request['comment']

        //];
        //Retirement_death::where('id', $id)
            //->update($input);
        $Retirement_death = Retirement_death::find($id);

        $Retirement_death->staff_no = $request->get('staff_no');
        $Retirement_death->name = $request->get('name');
        $Retirement_death->claimtype_id = $request->get('claimtype_id');
        $Retirement_death->interests_id = $request->get('interests_id');
        $Retirement_death->incident_date = $request->get('incident_date');
        $Retirement_death->total_contribution = $request->get('total_contribution');
        $Retirement_death->tc_dot_amount = $request->get('tc_dot_amount');
        $Retirement_death->benefit_amount = $benefit_amount;
        $Retirement_death->balance_amount = $balance_amount;
        $Retirement_death->comment = $request->get('comment');
        $Retirement_death->amount_paid = $request->get('amount_paid');

        $Retirement_death->save();

        $employee = Employee::where('staff_number', $request->get('staff_no'))->first();
        $employee->active_id = 2; // active type 2 means no more active
        $employee->save();

        return redirect('retirement-death')->with('success','Record update');

       // return redirect()->intended('retirement-death');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Retirement_death::where('id', $id)->delete();
         return redirect()->intended('retirement-death');
    }

    public function search(Request $request) {

       // return $request->all();

        $constraints = ['staff_no' => $request['staff_number']];
        $result = $this->doSearchingQuery($constraints);

        $Retirement_death = Retirement_death::where('staff_no', '=', $constraints['staff_no'])->first();
        if ($Retirement_death != null) {
        // user doesn't exist
            return response()->json('Staff Id already retired');
            // { status: true }
       }else{
        // staff number does not exists

        $ClaimTypes = ClaimType::all();
        $interest = interest::all();

         return view('retirement-death/create')->with(['employee' => $result['employee'], 'sum' => $result['sum'], 'searchingVals' => $constraints, 'ClaimTypes' => $ClaimTypes, 'interest' => $interest]);



       }
    }

    private function doSearchingQuery($constraints) {
        // $employee = DB::table('employees')
        // ->select('employees.firstname as employee_name', 'employees.*' )
        // ->where('staff_number', $constraint['staff_number'])->first();

     $employee =  Employee::where('staff_number', $constraints['staff_no'])->first();
     $sumOfContributions = $employee->clientContributions()->sum('contribution_amount');
     //->with('clientContributions')->get();

     return ['employee' => $employee, 'sum' => $sumOfContributions ];



//         $fields = array_keys($constraints);
//         $index = 0;
//         foreach ($constraints as $constraint) {
//             if ($constraint != null) {
//                 $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
//             }

//             $index++;
// }

}



public function search_1(Request $request) {
$constraints = [
            'staff_no' => $request['staff_no']
            ];

       $Retirement_death = $this->doSearchingQuery1($constraints);
       return view('retirement-death/index', ['Retirement_death' => $Retirement_death, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery1($constraints) {
        $query = DB::table('retirement_deaths')
        ->leftJoin('claim_types', 'retirement_deaths.claimtype_id', '=', 'claim_types.id')
        ->leftJoin('interests', 'retirement_deaths.interests_id', '=', 'interests.id')
        ->select('retirement_deaths.*', 'claim_types.claimtype_name as claimtype_name', 'claim_types.id as claimtype_id', 'interests.interest_amount as interest_amount', 'interests.id as interests_id');
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }

    private function validateInput($request) {
        $this->validate($request, [
            'staff_no' => 'required',
            'name' => 'required',
            'claimtype_id' => 'required',
            'interests_id' => 'required',
            'incident_date' => 'required',
            'total_contribution' => 'required',
            'tc_dot_amount' => 'required',
            'benefit_amount' => 'required',
            'balance_amount' => 'required',
            'comment' => 'required',
            'amount_paid' => 'required',

    ]);
    }

        private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }





}
