<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Employee;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\fundtype;
use App\State;
use App\Country;
use App\Department;
use App\Division;
use App\sex;
use App\active;
use App\bank;
use App\Pictureupload;
use Carbon\Carbon;
use Response;

class RetirementController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
        $employees = Employee::all();
        $sex = sex::all();
        $active = active::all();
        $fundtype = fundtype::all();
        $department = Department::all();
        $division = Division::all();
        $bank = bank::all();
        $pictureupload = Pictureupload::all();
        $state = State::all();

       date_default_timezone_set('asia/ho_chi_minh');
        $format = '';
        $now = date($format);
        $to = date($format, strtotime("+30 days"));
        $constraints = [
            'age' => $now,
            'active_type' => $to,

        ];

        
        $employees = $this->getbirthdateEmployees($constraints);
        return view('reports/retirement-report/index', ['employees' => $employees, 'searchingVals' => $constraints, 'active' => $active ]);
    }

    public function exportExcel(Request $request) {
        //return $this->prepareExportingData($request);
        $this->prepareExportingData($request)->export('xlsx');
    //   echo 'everything is fine';
    //     return;
        redirect()->intended('reports/retirement-report')->with('clientContributions');
    }

    public function exportPDF(Request $request) {
         $constraints = [
            'age' => $request['age'],
            'active_type' => $request['active_id'],
            
        ];
        $active = active::first();
        $pictureupload = Pictureupload::first();
        $state = State::first();
        
        $employees = $this->getExportingData($constraints);
        $pdf = PDF::loadView('reports/retirement-report/pdf', ['employees' => $employees, 'searchingVals' => $constraints, 'active' => $active, 'pictureupload' => $pictureupload, 'state' => $state]);
        $pdf->setPaper('A4', 'landscape');
        return $pdf->stream('report_from_'. $request['age'].'and above'.'pdf');

    }
    private function prepareExportingData($request) {
        $age = Carbon::parse($request->birthdate)->age;
        $active = active::first();
        $author = Auth::user()->username;
        $employees = $this->getExportingData(['age'=> $request['age'], 'active_type' => $request['active_id']]);

        
        return Excel::create('report_from_'. $request['age']. $request['active_id'], function($excel) use($employees, $request, $author) {

        // // Set the title
        $excel->setTitle('List of retired clients from' . $request['age']. 'and above');

        // // Chain the setters
        $excel->setCreator($author)
            ->setCompany('HoaDang');

        // // Call them separately
        $excel->setDescription('List of Cients on Retirement ');

            $excel->sheet('Retired_Employees', function($sheet) use($employees) {
                
                $csv= json_decode( json_encode($employees), true);
                
                $sheet->fromArray($csv);
                
            });
            
            
        });
        
    
    }
    public function search(Request $request) {
        $constraints = [
            'age' => $request['age'],
            'active_type' => $request['active_id'],
                    ];
                    
            $active = active::all();
            $state = State::all();

        $employees = $this->getbirthdateEmployees($constraints);
        
        return view('reports/retirement-report/index', ['employees' => $employees, 'searchingVals' => $constraints, 'active' => $active, 'state' => $state]);
    }
    private function getbirthdateEmployees($constraints) {
        $employees = Employee::where('age', '>=', $constraints['age'])
                        ->where('active_id', '=', $constraints['active_type'])
                        
                        ->get();
        return $employees;
    }

    private function getExportingData($constraints) {
        return DB::table('employees')
        ->leftJoin('department', 'employees.department_id', '=', 'department.id')
        ->leftJoin('state', 'employees.state_id', '=', 'state.id')
        ->leftJoin('country', 'employees.country_id', '=', 'country.id')
        ->leftJoin('division', 'employees.division_id', '=', 'division.id')
        ->leftJoin('sexes', 'employees.sex_id', '=', 'sexes.id')
        ->leftJoin('fundtypes', 'employees.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('actives', 'employees.active_id', '=', 'actives.id')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.*', 'department.name as department_name', 'division.name as division_name', 'state_name as state_name', 'active_type as active_type','sex_type as sex_type', 'fundtype_name as fundtype_name', 'country_name as country_name', 'bank_name as bank_name')
        ->where('age', '>=', $constraints['age'])
        ->where('active_id', '=', $constraints['active_type'])
        ->orderBy('state_name')
        ->get();
        
        //->groupBy('state_name')
        
        
    }
    /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
         $path = storage_path().'./app/avatars/'.$name;
        if (file_exists($path)) {
            return Response::download($path);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
