<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\residentialstatus;

class ResidentialstatusController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $residentialstatus = residentialstatus::paginate(5);

        return view('system-mgmt/residential/index', ['residentialstatus' => $residentialstatus]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/residential/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         residentialstatus::create([
            'residential_type' => $request['residential_type']
        ]);

        return redirect()->intended('system-management/residential');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $residentialstatuss = residentialstatus::find($id);
        return view('system-mgmt/residential/edit', compact('residentialstatuss', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $residentialstatus = residentialstatus::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'residential_type' => $request['residential_type']
        ];
        residentialstatus::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/residential');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        residentialstatus::where('id', $id)->delete();
         return redirect()->intended('system-management/residential');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'residential_type' => $request['residential_type']
            ];

       $residentialstatus = $this->doSearchingQuery($constraints);
       return view('system-mgmt/residential/index', ['residentialstatus' => $residentialstatus, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = residentialstatus::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'residential_type' => 'required|max:60|unique:residentialstatuses'
    ]);
    }
}
