<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\reasonforwithdrawal;

class ReasonforwithdrawalController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $reasonforwithdrawal = reasonforwithdrawal::paginate(5);

        return view('system-mgmt/reasonforwithdrawal/index', ['reasonforwithdrawal' => $reasonforwithdrawal]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/reasonforwithdrawal/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         reasonforwithdrawal::create([
            'withdrawalreasons' => $request['withdrawalreasons']
        ]);

        return redirect()->intended('system-management/reasonforwithdrawal');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $reasonforwithdrawals = reasonforwithdrawal::find($id);
        return view('system-mgmt/reasonforwithdrawal/edit', compact('reasonforwithdrawals', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $reasonforwithdrawal = reasonforwithdrawal::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'withdrawalreasons' => $request['withdrawalreasons']
        ];
        reasonforwithdrawal::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/reasonforwithdrawal');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         reasonforwithdrawal::where('id', $id)->delete();
         return redirect()->intended('system-management/reasonforwithdrawal');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'withdrawalreasons' => $request['withdrawalreasons']
            ];

       $reasonforwithdrawal = $this->doSearchingQuery($constraints);
       return view('system-mgmt/reasonforwithdrawal/index', ['withdrawalreasons' => $withdrawalreasons, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = reasonforwithdrawal::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'withdrawalreasons' => 'required|max:120|unique:reasonforwithdrawals'
    ]);
    }
}
