<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\Pictureupload;
use Illuminate\Support\Facades\Storage;

class PictureuploadController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pictureupload = Pictureupload::all();
        
       return view('system-mgmt/picture/index', ['pictureupload' => $pictureupload]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/picture/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);

        // Upload image
        // $path = $request->file('picture')->store('avatars');
        $path = Storage::disk('public')->putFile('avatars', $request->file('picture'));
        $input = $this->createQueryInput($request);
        $input['picture'] = $path;

        // Not implement yet
        // $input['company_id'] = 0;
        Pictureupload::create($input);
        //dd(request()->all());
        return redirect()->intended('system-management/picture')->with('success', 'Logo Added Sucessfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pictureuploads = Pictureupload::find($id);
        // Redirect to state list if updating state wasn't existed
        return view('system-mgmt/picture/edit', compact('pictureuploads', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $pictureuploads = Pictureupload::findOrFail($id);
        $this->validateInput($request);
        // Upload image
        $input = $this->createQueryInput($request);
        if ($request->file('picture')) {
            $path = Storage::disk('public')->putFile('avatars', $request->file('picture'));
            $input['picture'] = $path;
        }

        Pictureupload::where('id', $id)
            ->update($input);

        return redirect()->intended('system-management/picture');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Pictureupload::where('id', $id)->delete();
         return redirect()->intended('system-management/picture');
    }

    /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
         $path = storage_path().'/app/avatars/'.$name;
        if (file_exists($path)) {
            return Response::download($path);
        }
}

    private function createQueryInput($request) {
        //

        }
    

    private function validateInput($request) {
        $this->validate($request, [
            
            
            
            
    ]);
    }
}
