<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Employee;
use Auth;
use App\Models\bank;
use Excel;
use PDF;
use Response;



class PersonalController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employees = DB::table('employees')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.*' , 'employees.staff_number', 'employees.account_number', 'employees.branch_name', 'bank_name as bank_name')
        ->paginate(5);
        return view('other-employee-details/personal/index', ['employees' => $employees]);
        
    }

    /**
     * Search state from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'staff_number' => $request['staff_number'],
            ];
        $employees = $this->doSearchingQuery($constraints);
        $constraints['staff_number'] = $request['staff_number']; 
        return view('other-employee-details/personal/index', ['employees' => $employees, 'searchingVals' => $constraints]);
    }

    public function exportExcel(Request $request) {
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('other-employee-details/personal');
    }

    private function prepareExportingData($request) {
        $author = Auth::user()->username;
        $employees = $this->getExportingData(['staff_number'=> $request['staff_number']]);
            //, 'city_name' => $request['city_name', 'state_name' => $request['state_name']]);
        return Excel::create('report_for_'. $request['staff_number'], function($excel) use($employees, $request, $author) {

        // Set the title
        $excel->setTitle('List of clients from '. $request['staff_number']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('SICBrokerge');

        // Call them separately
        $excel->setDescription('The list of clients');

        $excel->sheet('List of clients', function($sheet) use($employees) {

        $sheet->fromArray($employees);
            });
        });

    }

    private function getExportingData($constraints) {
        return DB::table('employees')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.*', 'employees.staff_number', 'employees.account_number', 'employees.branch_name', 'bank_name as bank_name' )
        ->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();
    }

    public function exportPDF(Request $request) {
         $constraints = [
            'staff_number' => $request['staff_number'],
        ];
        $employees = $this->getExportingData($constraints);
        $pdf = PDF::loadView('other-employee-details/personal/pdf', ['employees' => $employees, 'searchingVals' => $constraints]);
        return $pdf->download('report_from_'. $request['staff_number'].'_to_'.$request['staff_number'].'pdf');

    }

    private function doSearchingQuery($constraints) {
        $query = DB::table('employees')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.*', 'employees.staff_number', 'employees.account_number', 'employees.branch_name', 'bank_name as bank_name' );
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
}

}