<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\fundtype;
use App\Models\State;
use App\Models\Country;
use App\Models\sex;
use App\Models\active;
use App\Models\bank;
use Response;
use App\Models\Regional;
use App\Models\Pictureupload;

class OnlineclientController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
        $active = active::all();
        $employees = Employee::with(['fundtype','region','Country', 'active', 'sex', 'bank'])->get();
        
        date_default_timezone_set('asia/ho_chi_minh');
        $format = '';
        $now = date($format);
        $to = date($format, strtotime("+30 days"));
        $too = date($format, strtotime("+30 days"));
        $constraints = [
            'from' => $now,
            'to' => $to,
            'active_type' => $too
        ];
       
        $employees = $this->getdatecreatedEmployees($constraints);
        
        return view('reports/onlineclient/index', ['employees' => $employees, 'active' => $active, 'searchingVals' => $constraints]);
        

}

        public function exportExcel(Request $request) {
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('reports/onlineclient');
        }
        
        
        public function exportPDF(Request $request) {
         $constraints = [
            'from' => $request['from'],
            'to' => $request['to'],
            'active_type' => $request['active_id'],
        ];
        
        
        $active = active::first();
        $pictureupload = Pictureupload::first();
        $sex = sex::first();
        $bank = bank::first();
        $regions = Regional::first();

        $employees = $this->getExportingData($constraints);
        $pdf = PDF::loadView('reports/onlineclient/pdf', ['employees' => $employees, 'searchingVals' => $constraints, 'active' => $active, 'sex' => $sex, 'pictureuploads' => $pictureupload, 'bank' => $bank, 'regions' => $regions]);

        $pdf->setPaper('A4', 'landscape');
        return $pdf->stream('report_for_'. $request['active_type'].'pdf');
        
        }
        
        private function prepareExportingData($request) {

        $active = active::first();
        $author = Auth::user()->username;
        $employees = $this->getExportingData(['active_type'=> $request['active_id']]);
            //, 'city_name' => $request['city_name', 'state_name' => $request['state_name']]);
        return Excel::create('report_for_'. $request['active_type'], function($excel) use($employees, $request, $author) {

        // Set the title
        $excel->setTitle('List of online clients  '. $request['active_type']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('SICBrokerge');

        // Call them separately
        $excel->setDescription('The list of online clients');

        $excel->sheet('List of clients', function($sheet) use($employees) {

        $sheet->fromArray($employees);
            });
        });
        
        }
        
        /**
     * Search sector from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'from' => $request['from'],
            'to' => $request['to'],
            'active_type' => $request['active_id'],
            ];

            $active = active::all();
            


        $employees = $this->getdatecreatedEmployees($constraints);
        $constraints['active_type'] = $request['active_id'];
        return view('reports/onlineclient/index', ['employees' => $employees, 'active' => $active, 'searchingVals' => $constraints]);
    }

    private function getdatecreatedEmployees($constraints) {
        $employees = Employee::where('active_id', '=', $constraints['active_type'])
                            ->where('employees.created_at', '>=', $constraints['from'])
                        ->where('employees.created_at', '<=', $constraints['to'])
                        ->get();
        
        return $employees;
    }

    private function getExportingData($constraints) {
        return DB::table('employees')
        ->leftJoin('department', 'employees.department_id', '=', 'department.id')
        ->leftJoin('state', 'employees.state_id', '=', 'state.id')
        ->leftJoin('country', 'employees.country_id', '=', 'country.id')
        ->leftJoin('division', 'employees.division_id', '=', 'division.id')
        ->leftJoin('sexes', 'employees.sex_id', '=', 'sexes.id')
        ->leftJoin('fundtypes', 'employees.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('actives', 'employees.active_id', '=', 'actives.id')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.firstname as employee_name', 'employees.*','department.name as department_name', 'division.name as name', 'state_name as state_name', 'active_type as active_type', 'sex_type as sex_type', 'fundtype_name as fundtype_name', 'country_name as country_name', 'bank_name as bank_name' )
        
        ->where('employees.created_at', '>=', $constraints['from'])
        ->where('employees.created_at', '<=', $constraints['to']) 
        ->where('active_id', '=', $constraints['active_type'])
        ->get()

        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

        return ['active' => $active, 'employees' =>  $employees];
    }


     /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
         $path = storage_path().'/app/avatars/'.$name;
        if (file_exists($path)) {
            return Response::download($path);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
