<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\nextofkin;
use App\Models\Employee;


class NextofkinController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($empId)
    {
        $employees = Employee::find($empId);
        $nextofkin = nextofkin::all();
        $nextofkin = nextofkin::paginate(5);
       return view('other-employee-details/nextofkin/index')->with(['nextofkin' => $nextofkin, 'employee' => $employees]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $nextofkin = nextofkin::all();
        return view('other-employee-details/nextofkin/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, array(
            'clients_name' => 'required',
            'name_of_beneficiary_1' => 'required',
            'relationship_1' => 'required',
            'contact_1' => 'required',
            'percentage_1' => 'required',
            'name_of_beneficiary_2' => 'required',
            'relationship_2' => 'required',
            'contact_2' => 'required',
            'percentage_2' => 'required',
            'name_of_beneficiary_3' => 'required',
            'relationship_3' => 'required',
            'contact_3' => 'required',
            'percentage_3' => 'required',
            'name_of_beneficiary_4' => 'required',
            'relationship_4' => 'required',
            'contact_4' => 'required',
            'percentage_4' => 'required',
            'name_of_beneficiary_5' => 'required',
            'relationship_5' => 'required',
            'contact_5' => 'required',
            'percentage_5' => 'required',

        ));

        $nextofkin = new nextofkin;

        $nextofkin->clients_name = $request->clients_name;
        $nextofkin->name_of_beneficiary_1 = $request->name_of_beneficiary_1;
        $nextofkin->relationship_1 = $request->relationship_1;
        $nextofkin->contact_1 = $request->contact_1;
        $nextofkin->percentage_1 = $request->percentage_1;
        $nextofkin->name_of_beneficiary_2 = $request->name_of_beneficiary_2;
        $nextofkin->relationship_2 = $request->relationship_2;
        $nextofkin->contact_2 = $request->contact_2;
        $nextofkin->percentage_2 = $request->percentage_2;
        $nextofkin->name_of_beneficiary_3 = $request->name_of_beneficiary_3;
        $nextofkin->relationship_3 = $request->relationship_3;
        $nextofkin->contact_3 = $request->contact_3;
        $nextofkin->percentage_3 = $request->percentage_3;
        $nextofkin->name_of_beneficiary_4 = $request->name_of_beneficiary_4;
        $nextofkin->relationship_4 = $request->relationship_4;
        $nextofkin->contact_4 = $request->contact_4;
        $nextofkin->percentage_4 = $request->percentage_4;
        $nextofkin->name_of_beneficiary_5 = $request->name_of_beneficiary_5;
        $nextofkin->relationship_5 = $request->relationship_5;
        $nextofkin->contact_5 = $request->contact_5;
        $nextofkin->percentage_5 = $request->percentage_5;

        $post->save();

        

        return redirect()->intended('/other-employee-details/nextofkin');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $nextofkins = nextofkin::find($id);
        return view('other-employee-details/nextofkin/edit', compact('nextofkins', 'id'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $nextofkin = nextofkin::find($id);
        
        $nextofkin->clients_name = $request->get('clients_name');
        $nextofkin->name_of_beneficiary_1 = $request->get('name_of_beneficiary_1');
        $nextofkin->relationship_1 = $request->get('relationship_1');
        $nextofkin->contact_1 = $request->get('contact_1');
        $nextofkin->percentage_1 = $request->get('percentage_1');
        $nextofkin->name_of_beneficiary_2 = $request->get('name_of_beneficiary_2');
        $nextofkin->relationship_2 = $request->get('relationship_2');
        $nextofkin->contact_2 = $request->get('contact_2');
        $nextofkin->percentage_2 = $request->get('percentage_2');
        $nextofkin->name_of_beneficiary_3 = $request->get('name_of_beneficiary_3');
        $nextofkin->relationship_3 = $request->get('relationship_3');
        $nextofkin->contact_3 = $request->get('contact_3');
        $nextofkin->percentage_3 = $request->get('percentage_3');
        $nextofkin->name_of_beneficiary_4 = $request->get('name_of_beneficiary_4');
        $nextofkin->relationship_4 = $request->get('relationship_4');
        $nextofkin->contact_4 = $request->get('contact_4');
        $nextofkin->percentage_4 = $request->get('percentage_4');
        $nextofkin->name_of_beneficiary_5 = $request->get('name_of_beneficiary_5');
        $nextofkin->relationship_5 = $request->get('relationship_5');
        $nextofkin->contact_5 = $request->get('contact_5');
        $nextofkin->percentage_5 = $request->get('percentage_5');
        $nextofkin->save();
        
        return redirect('other-employee-details/nextofkin');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $nextofkin = nextofkin::find($id);
        $nextofkin->delete();

         return redirect('other-employee-details/nextofkin')->with('success','Record deleted');

     }

    /**
     * Search department from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
       $constraints = [
            
            'name_of_beneficiary_1' => $request['name_of_beneficiary_1'],
            'relationship_1' => $request['relationship_1'],
            'contact_1' => $request['contact_1'],
            'percentage_1' => $request['percentage_1'],
            'name_of_beneficiary_2' => $request['name_of_beneficiary_2'],
            'relationship_2' => $request['relationship_2'],
            'contact_2' => $request['contact_2'],
            'percentage_2' => $request['percentage_2'],
            'name_of_beneficiary_3' => $request['name_of_beneficiary_3'],
            'relationship_3' => $request['relationship_3'],
            'contact_3' => $request['contact_3'],
            'percentage_3' => $request['percentage_3'],
            'name_of_beneficiary_4' => $request['name_of_beneficiary_4'],
            'relationship_4' => $request['relationship_4'],
            'contact_4' => $request['contact_4'],
            'percentage_4' => $request['percentage_4'],
            'name_of_beneficiary_5' => $request['name_of_beneficiary_5'],
            'relationship_5' => $request['relationship_5'],
            'contact_5' => $request['contact_5'],
            'percentage_5' => $request['percentage_5'],
            ];
        $employee = $this->doSearchingQuery($constraints);
        $constraints = [
            'firstname' => $request['firstname'],];
        return view('other-employee-details/nextofkin/index', ['employee' => $employee, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = Employee::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
    
    ]);
    }
}































