<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\Employee;
use App\Models\ClaimType;
use App\Models\Interestcalculator;
use App\Models\client_contribution;
use App\Models\csv_data;
use Carbon\Carbon;
use App\Models\Transaction;
use App\Models\Monthlyint;

class MonthlyintController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       
        $Transaction = Transaction::all();
        $employees = Employee::all();
        $client_contribution= client_contribution::all();
        $Monthlyint = DB::table('monthlyints')
        ->leftJoin('transactions', 'monthlyints.transaction_id', '=', 'transactions.id')
        ->select('monthlyints.*', 'transactions.transaction_type as transaction_type', 'transactions.id as transaction_id')
        ->paginate(20);
        
        

        //return  ['Retirement_death' => $Retirement_death];

        return view('monthlyint/index', ['Monthlyint' => $Monthlyint]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $Transaction = Transaction::all();
        $Monthlyint = Monthlyint::all();
        return view('monthlyint/create',['Transaction' => $Transaction]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //$narration = $request->narration;
        //$date_of_commencement = $request->date_of_commencement;
        //$date_of_completion = $request->date_of_completion;


        // diff btn dates

        
      // $number_of_days_run = Carbon::parse($date_of_commencement)->diffInDaysFiltered(function(Carbon $date) {
        //    return $date->subDay();
        // }, $date_of_completion);


       
        // loop through all the selected users
        $membersArray = $request->agree;
        foreach($membersArray as $clientNo){

           // Get the contribution of from the contribution table by the clientNo
            // this return the row of the given staff [name, contribution_amount, ]

            // $contributionRow = client_contribution::where('staff_no', '=', $staffNo)->first();
         $contributionRow = client_contribution::where('clientaccount_number','=', $clientNo)
            ->where('contribution_month', '=', $request->intMonth)
            ->where('year', '=', $request->intYear)
            ->select('contribution_month as month', 'contribution_amount as amount', 'clientaccount_number', 'name', 'year')
            ->get();


            // dd($contributionRow);

            $Transaction = Transaction::find($request->transaction_id);

           /* $interest_accrued = $request->tbills*$contributionRow[0]->amount*$tbillsRecord->tbillsint_amount * $tbillsRecord->tbillsint_amount/$tbillsRecord->tbillsint_amount ;*/



           $interest_accrued = $request->interest*$contributionRow[0]->amount;



        $total_amount = $interest_accrued+$contributionRow[0]->amount;

       // $maturity_days = $maturity_days;

        

        $Monthlyint = new Monthlyint;

        $Monthlyint->clientaccount_number = $contributionRow[0]->clientaccount_number;
        $Monthlyint->name = $contributionRow[0]->name;
        $Monthlyint->incident_date = $request->incident_date;
        $Monthlyint->contribution_amount = $contributionRow[0]->amount;
        $Monthlyint->interest = $request->interest;
        $Monthlyint->transaction_id = $request->transaction_id;
        $Monthlyint->interest_accrued = $interest_accrued;
        $Monthlyint->contribution_month= $contributionRow[0]->month;
        $Monthlyint->year = $contributionRow[0]->year;
        $Monthlyint->total_amount = $total_amount;
        $Monthlyint->narration = $request->narration;
       // $Interestcalculator->date_of_commencement =$request->date_of_commencement;
       // $Interestcalculator->date_of_completion = $request->date_of_completion;
       // $Interestcalculator->number_of_days_run = $number_of_days_run;
       // $Interestcalculator->maturity_days = $maturity_days;
        

        $Monthlyint->save();

    
        $this->creditAccount($Monthlyint['clientaccount_number'], $Monthlyint['total_amount']);

    }

     // $totaltransactions1->save();

        return redirect('monthlyint')->with('success','Data Saved Successful');

    }

    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function search(Request $request) {

       $constraints = [
            'contribution_month' => $request['contribution_month'],
            'year' => $request['year'],
        ];

        
        // dd($constraints);

        

        $client_contributions = $this->getmonthclient_contribution($constraints);

        $Transaction = Transaction::all();
        return view('monthlyint/create', ['client_contribution' => $client_contributions, 'searchingVals' => $constraints, 'Transaction' => $Transaction]);

    }

    private function getmonthclient_contribution($constraints) {
        $client_contributionobj = client_contribution::where('contribution_month', '=', $constraints['contribution_month'])
                        ->where('year', '=', $constraints['year']);
        if (auth()->user()->user_type !== 'admin') {
            $client_contributionobj->where('email',auth()->user()->email);
        }               
       $client_contribution = $client_contributionobj->get();

        return $client_contribution;



       }

    private function getExportingData($constraints) {
        $client_contributionobj =  DB::table('client_contributions')
        ->select('client_contributions.clientaccount_number', 'client_contributions.name', 'client_contributions.contribution_month', 'client_contributions.contribution_amount', 'client_contributions.year') 
        ->where('contribution_month', '=', $constraints['contribution_month'])
        ->where('year', '=', $constraints['year']);
        
        if (auth()->user()->user_type !== 'admin') {
            $client_contributionobj->where('email',auth()->user()->email);
        }               

       $client_contribution =  $client_contributionobj->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

        return $client_contribution;

    }

    
    

    public function search_1(Request $request) {
        $constraints = [
            'clientaccount_number' => $request['clientaccount_number']
        
            ];

       $Transaction = Transaction::first();
       
       $Monthlyint = $this->doSearchingQuery1($constraints);
       return view('monthlyint/index', ['Monthlyint' => $Monthlyint, 'searchingVals' => $constraints, 'Transaction' => $Transaction]);
    }

    private function doSearchingQuery1($constraints) {

        $obj = DB::table('Monthlyints')
        ->leftJoin('transactions', 'Monthlyints.transaction_id', '=', 'transactions.id')
        ->select('Monthlyints.*','transaction_type as transaction_type');

        $Transaction = Transaction::first();
        $query = Monthlyint::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }

    private function validateInput($request) {
        $this->validate($request, [
        'clientaccount_number' => 'required',
        'name' => 'required',
        'incident_date' => 'required',
        'contribution_amount' => 'required',
        'interest' => 'required',
        'interest_accrued' => 'required',
        'contribution_month'=> 'required',
        'year' => 'required',
        'total_amount' => 'required',
       // 'date_of_commencement' => 'required',
       // 'date_of_completion' => 'required',
      //  'number_of_days_run' => 'required',
        'narration' => 'required',
        'transaction_id' => 'required',
       

    ]);
    }

        private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }


    // this will increase client total contributino on any payment made
    private function creditAccount($clientaccount_number, $total_amount) {
    // Check if data exists
    $contAmount = DB::table('totaltransactions')->where('clientaccount_number', $clientaccount_number)->first();

    if ($contAmount) {
        // Update the total_amount field
        DB::table('totaltransactions')->where('clientaccount_number', $clientaccount_number)->update(['total_amount' => DB::raw('total_amount + '.$total_amount)]);
    } else {
        // Insert a new row with the clientaccount_number and total_amount
        DB::table('totaltransactions')->insert(['clientaccount_number' => $clientaccount_number, 'total_amount' => $total_amount]);
    }
}


}
