<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;
use App\Models\fundtype;
use App\Models\State;
use App\Models\Country;
use App\Models\Department;
use App\Models\Division;
use App\Models\sex;
use App\Models\active;
use App\Models\bank;
use Response;
use App\Models\client_contribution;
use App\Models\Retirement_death;

class MonthlycontributionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $fundtype = fundtype::all();
        
        $employees = Employee::with(['fundtype','region','Country','Department','Division', 'active'])->get();
        
        date_default_timezone_set('asia/ho_chi_minh');
        $format = '';
        $now = date($format);
        $to = date($format, strtotime("+30 days"));
        $too = date($format, strtotime("+30 days"));
        $constraints = [
            'from' => $now,
            'to' => $to,
            'fundtype_name' => $too
        ];
       
        $employees = $this->getdatecreatedEmployees($constraints);
        
        return view('reports/monthlycont/index', ['employees' => $employees, 'fundtype' => $fundtype, 'searchingVals' => $constraints]);
    }

    public function exportExcel(Request $request) {
        
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('reports/monthlycont');
    }

    public function exportPDF(Request $request) {
         $constraints = [
            'from' => $request['from'],
            'to' => $request['to'],
            'fundtype_name' => $request['fundtype_id'],
        ];

        $fundtype = fundtype::first();
        

        $employees = $this->getExportingData($constraints);
        $pdf = PDF::loadView('reports/monthlycont/pdf', ['employees' => $employees, 'searchingVals' => $constraints, 'fundtype' => $fundtype ]);

        $pdf->setPaper('A4', 'landscape');
        return $pdf->stream('report_from_'. $request['from'].'_to_'.$request['to'] . $request->fundtype_id.'pdf');
        // return view('system-mgmt/report/pdf', ['employees' => $employees, 'searchingVals' => $constraints]);
    }
    
    private function prepareExportingData($request) {

        $fundtype = fundtype::first();
        $author = Auth::user()->username;
        $employees = $this->getExportingData(['from'=> $request['from'], 'to' => $request['to'], 'fundtype_name'=> $request['fundtype_id']]);
       
        
        return Excel::create('report_from_'. $request['from'].'_to_'.$request['to']. $request['fundtype_id'], function($excel) use($employees, $fundtype, $request, $author) {

        // Set the title
        $excel->setTitle('List of created clients from '. $request['from'].' to '. $request['to']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('HoaDang');

        // Call them separately
        $excel->setDescription('The list of created clients');

        $excel->sheet('Created_Clients', function($sheet) use($employees) {

        $sheet->fromArray($employees);
            });
        });
    }

    public function search(Request $request) {
        $constraints = [
            'from' => $request['from'],
            'to' => $request['to'],
            'fundtype_name' => $request['fundtype_id'],
        ];

        $fundtype = fundtype::all();

        

        $employees = $this->getdatecreatedEmployees($constraints);
        return view('reports/monthlycont/index')->with(['employees' => $employees, 'fundtype' => $fundtype, 'searchingVals' => $constraints]);
    }

    private function getdatecreatedEmployees($constraints) {
        $employees = Employee::where('employees.created_at', '>=', $constraints['from'])
                        ->where('employees.created_at', '<=', $constraints['to'])
                        ->where('fundtype_id', '=', $constraints['fundtype_name'])
                        
                        ->get();

    
        
        return $employees;
        
    }

    private function getExportingData($constraints) {
        return DB::table('employees')
        ->leftJoin('department', 'employees.department_id', '=', 'department.id')
        ->leftJoin('state', 'employees.state_id', '=', 'state.id')
        ->leftJoin('country', 'employees.country_id', '=', 'country.id')
        ->leftJoin('division', 'employees.division_id', '=', 'division.id')
        ->leftJoin('sexes', 'employees.sex_id', '=', 'sexes.id')
        ->leftJoin('fundtypes', 'employees.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('actives', 'employees.active_id', '=', 'actives.id')
        ->leftJoin('banks', 'employees.bank_id', '=', 'banks.id')
        ->select('employees.*', 'department.name as department_name', 'division.name as division_name', 'state_name as state_name', 'active_type as active_type','sex_type as sex_type', 'fundtype_name as fundtype_name', 'country_name as country_name', 'bank_name as bank_name')
        ->where('employees.created_at', '>=', $constraints['from'])
        ->where('employees.created_at', '<=', $constraints['to'])
        ->where('fundtype_id', '=', $constraints['fundtype_name'])
        ->get()
        
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

        return ['fundtype' => $fundtype, 'employees' =>  $employees];
    }

    /**
     * Load image resource.
     *
     * @param  string  $name
     * @return \Illuminate\Http\Response
     */
    public function load($name) {
         $path = storage_path().'/app/avatars/'.$name;
        if (file_exists($path)) {
            return Response::download($path);
        }
    }

    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
