<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\modeofdeposite;

class ModeofdepositeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $modeofdeposite = modeofdeposite::paginate(5);

        return view('system-mgmt/modeofdeposite/index', ['modeofdeposite' => $modeofdeposite]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/modeofdeposite/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         modeofdeposite::create([
            'modeofdeposite' => $request['modeofdeposite']
        ]);

        return redirect()->intended('system-management/modeofdeposite');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $modeofdeposite = modeofdeposite::find($id);
        return view('system-mgmt/modeofdeposite/edit', compact('modeofdeposite', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $modeofdeposites = modeofdeposite::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'modeofdeposite' => $request['modeofdeposite']
        ];
        modeofdeposite::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/modeofdeposite');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        modeofdeposite::where('id', $id)->delete();
         return redirect()->intended('system-management/modeofdeposite');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'modeofdeposite' => $request['modeofdeposite']
            ];

       $modeofdeposite = $this->doSearchingQuery($constraints);
       return view('system-mgmt/modeofdeposite/index', ['modeofdeposite' => $modeofdeposite, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = modeofdeposite::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'modeofdeposite' => 'required|max:120|unique:modeofdeposites'
    ]);
    }
}
