<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\maritalstatus;

class MaritalstatusController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $maritalstatus = maritalstatus::paginate(5);

        return view('system-mgmt/maritalstatus/index', ['maritalstatus' => $maritalstatus]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('system-mgmt/maritalstatus/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validateInput($request);
         maritalstatus::create([
            'maritalstatus_type' => $request['maritalstatus_type']
        ]);

        return redirect()->intended('system-management/maritalstatus');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $division = Division::find($id);
        return view('system-mgmt/maritalstatus/edit', compact('maritalstatus', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $maritalstatuss = maritalstatus::findOrFail($id);
        $this->validateInput($request);
        $input = [
            'maritalstatus_type' => $request['maritalstatus_type']
        ];
        maritalstatus::where('id', $id)
            ->update($input);
        
        return redirect()->intended('system-management/maritalstatus');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        maritalstatus::where('id', $id)->delete();
         return redirect()->intended('system-management/maritalstatus');
    }

    /**
     * Search division from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'maritalstatus_type' => $request['maritalstatus_type']
            ];

       $maritalstatus = $this->doSearchingQuery($constraints);
       return view('system-mgmt/maritalstatus/index', ['maritalstatus' => $maritalstatus, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = maritalstatus::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }
    private function validateInput($request) {
        $this->validate($request, [
        'maritalstatus_type' => 'required|max:60|unique:maritalstatuses'
    ]);
    }
}
