<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\leave_request_form;
use App\User;
use Carbon\Carbon;




class LRequestController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = auth()->user();

        // this is the main admin --------
         if($user->id == 1){
           // $user = User::find($user_id);
             $leave_request_form = leave_request_form::all();
         }
         else{
             // these are other users

         // return $leave_request;
          $leave_request_form = $user->leave_request_form;
          //return $leave_request_form;
         
         }
       
        
       return view('leave_request_form/index')->with('leave_request_form', $leave_request_form);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $leave_request_form = leave_request_form::all();
        return view('leave_request_form/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'staff_ID' => 'required',
            'lastname' => 'required',
            'firstname' => 'required',
            'middlename' => 'required',
            'department' => 'required',
            'total_leave_days' => 'required',
            'start_leave_date' => 'required',
            'end_leave_date' => 'required',
            


        ]);

        // calculate leave days requested
        $start_leave_date = $request->start_leave_date;
        $end_leave_date = $request->end_leave_date;

        // diff btn leave dates
        $diff = Carbon::parse($start_leave_date)->diffInDaysFiltered(function(Carbon $date) {
            return !$date->isWeekend();
         }, $end_leave_date);

        // calculate outstanding leave days
        $outstanding_leave_days = $request->total_leave_days-$diff;

        

        $leave_request_form = new leave_request_form([

        'staff_ID' => $request->get('staff_ID'),
        'lastname' => $request->get('lastname'),
        'firstname' => $request->get('firstname'),
        'middlename' => $request->get('middlename'),
        'department' => $request->get('department'),
        'total_leave_days' => $request->get('total_leave_days'),
        'start_leave_date' => $request->get('start_leave_date'),
        'end_leave_date' => $request->get('end_leave_date'),
        'leave_days_requested' => $diff,
        'outstanding_leave_days' => $outstanding_leave_days

    ]);
        $leave_request_form->user_id = Auth()->user()->id;
        $leave_request_form->save();

        
        return redirect()->intended('/leave_request_form')->with('success', 'Data Added Sucessfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $leave_request_form = leave_request_form::find($id);
        // Redirect to state list if updating state wasn't existed
        if ($leave_request_form == null) {
            return redirect()->intended('/leave_request_form');
    }

        return view('leave_request_form/edit', ['leave_request_form' => $leave_request_form]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $leave_request_form = leave_request_form::findOrFail($id);
        $this->validate($request, [
            'staff_ID' => 'required',
            'lastname' => 'required',
            'firstname' => 'required',
            'middlename' => 'required',
            'department' => 'required',
            'total_leave_days' => 'required',
            'start_leave_date' => 'required',
            'end_leave_date' => 'required',
            'leave_days_requested' => 'required',
            'outstanding_leave_days' => 'required',
        ]);

        
        $leave_request_form = leave_request_form::find($id);
        $leave_request_form->staff_ID = $request->get('staff_ID');
        $leave_request_form->lastname = $request->get('lastname');
        $leave_request_form->firstname = $request->get('firstname');
        $leave_request_form->middlename = $request->get('middlename');
        $leave_request_form->department = $request->get('department');
        $leave_request_form->total_leave_days = $request->get('total_leave_days');
        $leave_request_form->start_leave_date = $request->get('start_leave_date');
        $leave_request_form->end_leave_date = $request->get('end_leave_date');
        $leave_request_form->leave_days_requested = $request->get('leave_days_requested');
        $leave_request_form->outstanding_leave_days = $request->get('outstanding_leave_days');
        $leave_request_form->save();

        
    
        return redirect()->route('leave_request_form/index');

        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       leave_request_form::where('id', $id)->delete();
         return redirect()->intended('/leave_request_form');
    }

    /**
     * Search state from database base on some specific constraints
     *
     * @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     */
    public function search(Request $request) {
        $constraints = [
            'staff_ID' => $request['staff_ID'],
            'lastname' => $request['lastname'],
            'firstname' => $request['firstname'],
            'middlename' => $request['middlename'],
            'department' => $request['department'],
            'total_leave_days' => $request['total_leave_days'],
            'start_leave_date' => $request['start_leave_date'],
            'end_leave_date' => $request['end_leave_date'],
            'leave_days_requested' => $request['leave_days_requested'],
            'outstanding_leave_days' => $request['outstanding_leave_days'],

            ];
        $leave_request_form = $this->doSearchingQuery($constraints);
        $constraints['firstname'];
        return view('leave_request_form/index', ['leave_request_form' => $leave_request_form, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery($constraints) {
        $query = leave_request_form::query();
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }

     
    

    private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }
}


