<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Employeeleave;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;

class LReportallController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employeeleaves = Employeeleave::all();

        return view('employee-leaves-details/leave-report-all/index', ['employeeleave' => $employeeleaves]);
  
    }

    public function exportPDF(Request $request) 
    {
         
        $employeeleaves = $this->getExportingData();
        $pdf = PDF::loadView('employee-leaves-details/leave-report-all/pdf', ['employeeleave' => $employeeleaves]);
        return $pdf->download('all_employee_leave'.'pdf');
    }

    private function getExportingData() {
        return DB::table('employeeleaves')
        ->select('employeeleaves.firstname', 'employeeleaves.middlename', 'employeeleaves.lastname', 
        'employeeleaves.leave_days_approved','employeeleaves.leave_days_carried_forward', 'employeeleaves.total_leave_days', 'employeeleaves.leave_days_requested', 'employeeleaves.outstanding_leave_days')
        ->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\LReportall  $lReportall
     * @return \Illuminate\Http\Response
     */
    public function show(LReportall $lReportall)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\LReportall  $lReportall
     * @return \Illuminate\Http\Response
     */
    public function edit(LReportall $lReportall)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\LReportall  $lReportall
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, LReportall $lReportall)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\LReportall  $lReportall
     * @return \Illuminate\Http\Response
     */
    public function destroy(LReportall $lReportall)
    {
        //
    }
}
