<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Employeeleave;
use Excel;
use Illuminate\Support\Facades\DB;
use Auth;
use PDF;

class LReportController extends Controller
{
     /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        date_default_timezone_set('asia/ho_chi_minh');
        $format = '';
        $now = date($format);
        $to = date($format, strtotime("+30 days"));
        $constraints = [
            'firstname' => $now,
            'firstname' => $to,
        ];

        $employeeleaves = $this->getfirstnameEmployeeleave($constraints);
        return view('employee-leaves-details/leave-report/index', ['employeeleave' => $employeeleaves, 'searchingVals' => $constraints]);
    }
    public function exportExcel(Request $request) {
        $this->prepareExportingData($request)->export('xlsx');
        redirect()->intended('employee-leaves-details/leave-report');
    }
    public function exportPDF(Request $request) {
         $constraints = [
            'firstname' => $request['firstname'],
            'firstname' => $request['firstname'],
        ];
        $employeeleaves = $this->getExportingData($constraints);
        $pdf = PDF::loadView('employee-leaves-details/leave-report/pdf', ['employeeleave' => $employeeleaves, 'searchingVals' => $constraints]);
        return $pdf->download('report_from_'. $request['from'].'_to_'.$request['to'].'pdf');
        
    }
    
    private function prepareExportingData($request) {
        $author = Auth::user()->username;
        $employeeleaves = $this->getExportingData(['from'=> $request['from'], 'to' => $request['to']]);
        return Excel::create('report_from_'. $request['from'].'_to_'.$request['to'], function($excel) use($employeeleaves, $request, $author) {

        // Set the title
        $excel->setTitle('List of employee leaves from '. $request['from'].' to '. $request['to']);

        // Chain the setters
        $excel->setCreator($author)
            ->setCompany('HoaDang');

        // Call them separately
        $excel->setDescription('The list of employee leaves');

        $excel->sheet('Employee_Names_Employeeleaves', function($sheet) use($employeeleaves) {

        $sheet->fromArray($employeeleaves);
            });
        });
    }

    public function search(Request $request) {
        $constraints = [
            'firstname' => $request['firstname'],
            'firstname' => $request['firstname'],
        ];

        $employeeleaves = $this->getfirstnameEmployeeleave($constraints);
        return view('employee-leaves-details/leave-report/index', ['employeeleave' => $employeeleaves, 'searchingVals' => $constraints]);

        $employeeleaves = $this->getAllEmployeeleave($constraints);
        return view('employee-leaves-details/leave-report/index', ['employeeleave' => $employeeleaves, 'searchingVals' => $constraints]);
    }

    private function getfirstnameEmployeeleave($constraints) {
        $employeeleaves = Employeeleave::where('firstname', '=', $constraints['firstname'])
                        ->where('firstname', '=', $constraints['firstname'])

                        ->get();
        return $employeeleaves;

    }

    private function getExportingData($constraints) {
        return DB::table('employeeleaves')
        ->select('employeeleaves.firstname', 'employeeleaves.middlename', 'employeeleaves.lastname', 
        'employeeleaves.leave_days_approved','employeeleaves.leave_days_carried_forward', 'employeeleaves.total_leave_days', 'employeeleaves.leave_days_requested', 'employeeleaves.outstanding_leave_days')
        ->where('firstname', '=', $constraints['firstname'])
        ->where('firstname', '=', $constraints['firstname'])
        ->get()
        ->map(function ($item, $key) {
        return (array) $item;
        })
        ->all();

    }

}
