<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use App\Models\Employee;
use App\Models\Fixedincometype;
use App\Models\Fixedincomeproduct;
use App\Models\client_contribution;
use App\Models\Interestratetype;
use App\Models\Interesttype;
use App\Models\Interest;
use App\Models\Investmentmodel;
use App\Models\Schdulemode;
use App\Models\fundtype;
use App\Models\interestday;

class InvestmentmodelController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employees = Employee::all();
        $Investmentmodel = DB::table('investmentmodels')
        ->leftJoin('fixedincometypes', 'investmentmodels.fixedincometype_id', '=', 'fixedincometypes.id')
        ->leftJoin('fixedincomeproducts', 'investmentmodels.fixedincomeproduct_id', '=', 'fixedincomeproducts.id')
        ->leftJoin('interestratetypes', 'investmentmodels.interestratetype_id', '=', 'interestratetypes.id')
        ->leftJoin('interesttypes', 'investmentmodels.interesttype_id', '=', 'interesttypes.id')
        ->leftJoin('interests', 'investmentmodels.interest_id', '=', 'interests.id')
        ->leftjoin('fundtypes', 'investmentmodels.fundtype_id', '=', 'fundtypes.id')
        ->leftjoin('schedulemodes', 'investmentmodels.schedulemode_id', '=', 'schedulemodes.id')
        ->leftJoin('interestdays', 'investmentmodels.interestdaybasis_id', '=', 'interestdays.id')
        ->select('investmentmodels.*', 'fixedincometypes.fixedincometype_name as fixedincometype_name', 'fixedincometypes.id as fixedincometype_id', 
            'fixedincomeproducts.fixedincomeproduct_name as fixedincomeproduct_name', 'fixedincomeproducts.id as fixedincomeproduct_id', 
            'interestratetypes.interestratetype as interestratetype', 'interestratetypes.id as interestratetype_id', 'interests.interest_amount as interest_amount', 'interests.id as interests_id', 'fundtypes.fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'schedulemodes.schedule_mode as schedule_mode', 'schedulemodes.id as schedulemode_id', 'interesttypes.interesttype as interesttype', 'interesttypes.id as interesttype_id', 'interestdays.interestdaybasis as interestdaybasis', 'interestdays.id as interestdaybasis_id')
        ->paginate(10);


        //return  ['Retirement_death' => $Retirement_death];

        return view('newinvestment/index', ['Investmentmodel' => $Investmentmodel]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $Investmentmodel = Investmentmodel::all();
        
        return view('newinvestment/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

            // dd($contributionRow);

            $interest = Transaction::find($request->transaction_id);

           /* $interest_accrued = $request->tbills*$contributionRow[0]->amount*$tbillsRecord->tbillsint_amount * $tbillsRecord->tbillsint_amount/$tbillsRecord->tbillsint_amount ;*/



           $interest_accrued = $request->interest*$contributionRow[0]->amount;



        $total_amount = $interest_accrued+$contributionRow[0]->amount;

       // $maturity_days = $maturity_days;

        

        $Monthlyint = new Monthlyint;

        $Monthlyint->clientaccount_number = $contributionRow[0]->clientaccount_number;
        $Monthlyint->name = $contributionRow[0]->name;
        $Monthlyint->incident_date = $request->incident_date;
        $Monthlyint->contribution_amount = $contributionRow[0]->amount;
        $Monthlyint->interest = $request->interest;
        $Monthlyint->transaction_id = $request->transaction_id;
        $Monthlyint->interest_accrued = $interest_accrued;
        $Monthlyint->contribution_month= $contributionRow[0]->month;
        $Monthlyint->year = $contributionRow[0]->year;
        $Monthlyint->total_amount = $total_amount;
        $Monthlyint->narration = $request->narration;
       // $Interestcalculator->date_of_commencement =$request->date_of_commencement;
       // $Interestcalculator->date_of_completion = $request->date_of_completion;
       // $Interestcalculator->number_of_days_run = $number_of_days_run;
       // $Interestcalculator->maturity_days = $maturity_days;
        

        $Monthlyint->save();

    
        $this->creditAccount($Monthlyint['clientaccount_number'], $Monthlyint['total_amount']);

    

     // $totaltransactions1->save();

        return redirect('monthlyint')->with('success','Data Saved Successful');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function loadFixedincome($FixedincomeproductId) {
        $Fixedincometype = Fixedincometype::where('fixedincomeproduct_id', '=', $FixedincomeproductId)->get(['id', 'fixedincomproduct_name']);

        return response()->json($Fixedincometype);
    }

    public function search(Request $request) {

       // return $request->all();

        $constraints = ['clientaccount_number' => $request['clientaccount_number']];
        $result = $this->doSearchingQuery($constraints);

        $Investmentmodel = Investmentmodel::where('clientaccount_number', '=', $constraints['clientaccount_number'])->first();
        if ($Investmentmodel != null) {
        // user doesn't exist
            return response()->json('Staff Id already retired');
            // { status: true }
       }else{
        // staff number does not exists

        $fundtype = fundtype::all();
        $interest = interest::all();
        $Fixedincometype = Fixedincometype::all();
        $Fixedincomeproduct = Fixedincomeproduct::all();
        $Interesttype = Interesttype::all();
        $interestday = interestday::all();

         return view('newinvestment/create')->with(['employee' => $result['employee'], 'sum' => $result['sum'], 'searchingVals' => $constraints, 'fundtype' => $fundtype, 'interest' => $interest, 'Fixedincometype' => $Fixedincometype, 'Fixedincomeproduct' => $Fixedincomeproduct, 'Interesttype' => $Interesttype, 'interestday' => $interestday]);



       }
    }

    private function doSearchingQuery($constraints) {
        // $employee = DB::table('employees')
        // ->select('employees.firstname as employee_name', 'employees.*' )
        // ->where('staff_number', $constraint['staff_number'])->first();

     $employee =  Employee::where('clientaccount_number', $constraints['clientaccount_number'])->first();
     $sumOfContributions = $employee->clientContributions()->sum('contribution_amount');
     //->with('clientContributions')->get();

     return ['employee' => $employee, 'sum' => $sumOfContributions ];



//         $fields = array_keys($constraints);
//         $index = 0;
//         foreach ($constraints as $constraint) {
//             if ($constraint != null) {
//                 $query = $query->where($fields[$index], 'like', '%'.$constraint.'%');
//             }

//             $index++;
// }

}



public function search_1(Request $request) {
$constraints = [
            'clientaccount_number' => $request['clientaccount_number']
            ];

       $Investmentmodel = $this->doSearchingQuery1($constraints);
       return view('newinvestment/index', ['Investmentmodel' => $Investmentmodel, 'searchingVals' => $constraints]);
    }

    private function doSearchingQuery1($constraints) {
        $query = DB::table('investmentmodels')
        ->leftJoin('fundtypes', 'investmentmodels.fundtype_id', '=', 'fundtypes.id')
        ->leftJoin('interests', 'investmentmodels.interests_id', '=', 'interests.id')
        ->select('investmentmodels.*', 'fundtypes.fundtype_name as fundtype_name', 'fundtypes.id as fundtype_id', 'interests.interest_amount as interest_amount', 'interests.id as interests_id');
        $fields = array_keys($constraints);
        $index = 0;
        foreach ($constraints as $constraint) {
            if ($constraint != null) {
                $query = $query->where( $fields[$index], 'like', '%'.$constraint.'%');
            }

            $index++;
        }
        return $query->paginate(5);
    }

    private function validateInput($request) {
        $this->validate($request, [
            'clientaccount_no' => 'required',
            'name' => 'required',
            'fundtype_id' => 'required',
            'fixedincometype_id' => 'required',
            'fixedincomeproduct_id' => 'required',
            'interesttype' => 'required',
            'interestday' => 'required',
            'interests_id' => 'required',
            'incident_date' => 'required',
            'total_contribution' => 'required',
            'tc_dot_amount' => 'required',
            'benefit_amount' => 'required',
            'balance_amount' => 'required',
            'comment' => 'required',
            'amount_paid' => 'required',

    ]);
    }

        private function createQueryInput($keys, $request) {
        $queryInput = [];
        for($i = 0; $i < sizeof($keys); $i++) {
            $key = $keys[$i];
            $queryInput[$key] = $request[$key];
        }

        return $queryInput;
    }

}





